/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.predicate;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.BranchSearchUtil;
import com.ericsson.ere.selectiontree.search.ConditionEvaluator;
import com.ericsson.ere.selectiontree.search.dataset.AccessTrackingDataSet;
import com.ericsson.ere.selectiontree.search.dataset.AccessTrackingDataSetImpl;
import com.ericsson.ere.selectiontree.search.dataset.DataSetHelper;
import com.ericsson.ere.selectiontree.search.dataset.DataSetParameter;
import com.ericsson.ere.selectiontree.search.dataset.DataSetParameters;
import com.ericsson.ere.selectiontree.search.dataset.DefaultParameterIdentifier;
import com.ericsson.ere.selectiontree.search.predicate.BranchPredicate;
import com.ericsson.ere.selectiontree.search.predicate.ConditionGroup;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DataSetBasedBranchPredicate
implements BranchPredicate {
    private final DataSet myDataSet;
    private final ConditionEvaluator myEvaluator;
    private final AccessTrackingDataSetImpl.ParameterIdentifier myParameterIdentifier;

    private DataSetBasedBranchPredicate(ConditionEvaluator evaluator, DataSet dataset, AccessTrackingDataSetImpl.ParameterIdentifier identifier) {
        this.myDataSet = dataset;
        this.myEvaluator = evaluator;
        this.myParameterIdentifier = identifier;
        this.myDataSet.putState(DataSetBasedBranchPredicate.class, new Object());
    }

    public static DataSetBasedBranchPredicate create(ConditionEvaluator evaluator, DataSet ds) {
        return DataSetBasedBranchPredicate.create(evaluator, ds, new DefaultParameterIdentifier());
    }

    public static DataSetBasedBranchPredicate create(ConditionEvaluator evaluator, DataSet ds, AccessTrackingDataSetImpl.ParameterIdentifier identifier) {
        if (evaluator == null || ds == null || identifier == null) {
            throw new IllegalArgumentException("Arguments must be non-null.");
        }
        if (ds instanceof AccessTrackingDataSet) {
            throw new IllegalArgumentException("The data set must not already be an AccessTrackingDataSet instance.");
        }
        if (ds.getState(DataSetBasedBranchPredicate.class) != null) {
            throw new IllegalArgumentException("The data set has been used for another predicate.");
        }
        return new DataSetBasedBranchPredicate(evaluator, ds, identifier);
    }

    @Override
    public synchronized BranchPredicate.Match matches(Branch b) {
        DataSet ds = this.prepareDataSet();
        HashSet<DataSetParameter> params = new HashSet<DataSetParameter>();
        boolean result = this.testBranchWithDataSet(b, ds, params);
        int score = 0;
        if (result) {
            double parameterUsagePct = this.calculateParameterUsage(ds, params);
            score = (int)Math.round(100.0 * parameterUsagePct);
        }
        return new BranchPredicate.Match(result, score);
    }

    private DataSet prepareDataSet() {
        DataSet clone = DataSetHelper.cloneDataSet(this.myDataSet);
        DataSet ds = AccessTrackingDataSetImpl.createAccessTrackingDataSet(clone, this.myParameterIdentifier);
        return ds;
    }

    private double calculateParameterUsage(DataSet ds, Set<DataSetParameter> params) {
        Set<DataSetParameter> parameters = DataSetParameters.parametersOf(ds).getAll();
        int count = parameters.size();
        int used = 0;
        for (DataSetParameter p : parameters) {
            boolean hasBeenUsed = params.contains(p);
            used += hasBeenUsed ? 1 : 0;
        }
        return count > 0 ? (double)used / (double)count : 0.0;
    }

    private boolean testBranchWithDataSet(Branch b, DataSet ds, Set<DataSetParameter> params) {
        TariffStructureNode[] elements = b.getBranchElements();
        return this.testBranchElements(elements, ds, params);
    }

    private boolean testBranchElements(TariffStructureNode[] elements, DataSet in, Set<DataSetParameter> params) {
        ConditionGroup group = this.createConditionGroupSequence(elements);
        boolean result = true;
        if (group != null) {
            result = group.evaluate(this.myEvaluator, in);
            params.addAll(group.getAccessedParameters());
        }
        return result;
    }

    private ConditionGroup createConditionGroupSequence(TariffStructureNode[] elements) {
        ConditionGroup lastGroup = null;
        for (int i = elements.length - 1; i >= 0; --i) {
            TariffStructureNode elem = elements[i];
            if (!SelectionTreeUtil.isNode(elem)) continue;
            int j = i + 1;
            boolean isInverted = BranchSearchUtil.isNodeInverted(elem);
            ArrayList<TariffStructureNode> conditions = new ArrayList<TariffStructureNode>();
            while (j < elements.length && SelectionTreeUtil.isCondition(elements[j])) {
                conditions.add(elements[j++]);
            }
            if (conditions.size() <= 0) continue;
            lastGroup = new ConditionGroup(isInverted, conditions, lastGroup);
        }
        return lastGroup;
    }
}

