/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.predicate;

import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.predicate.BranchPredicate;

public class ScoreCheckingBranchPredicate
implements BranchPredicate {
    private final int myLimit;
    private final boolean myMatchBelow;

    private ScoreCheckingBranchPredicate(int limit, boolean below) {
        this.myLimit = limit;
        this.myMatchBelow = below;
    }

    @Override
    public BranchPredicate.Match matches(Branch b) {
        if (!b.hasScore()) {
            return new BranchPredicate.Match(false, 0);
        }
        int points = b.getScore();
        boolean isBelow = points < this.myLimit;
        boolean match = this.myMatchBelow == isBelow;
        return new BranchPredicate.Match(match, points);
    }

    public static ScoreCheckingBranchPredicate createEqualOrAbove(int limit) {
        return new ScoreCheckingBranchPredicate(limit, false);
    }

    public static ScoreCheckingBranchPredicate createBelow(int limit) {
        return new ScoreCheckingBranchPredicate(limit, true);
    }
}

