/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.SelectionTreeQualifier;
import com.ericsson.ere.dataset.task.TreeTask;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeQualifierUser;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatement;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.XMLInitializable;
import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeStatement
extends AbstractNodeStatement
implements TraceableV2,
SelectionTreeQualifierUser {
    public static final String ATTR_CALLNEXTWHENFALSE = "CallNextWhenFalse";
    private boolean myIsInverted = false;
    public static final String TAG_COMMENT = "Comment";
    public static final String ATTR_STQ = "STQvalue";
    private SelectionTreeQualifier mySTQualifier;

    public NodeStatement(String name, boolean isInverted) {
        super(name);
        this.myIsInverted = isInverted;
        this.myChildren = new ArrayList();
        this.myConditions = new ArrayList();
    }

    public NodeStatement(String name) {
        super(name);
    }

    public NodeStatement() {
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        NamedNodeMap attr = null;
        if (iterator.hasAttributes()) {
            attr = iterator.getAttributes();
        }
        if (attr != null) {
            Node stqNode;
            Node node = attr.getNamedItem(ATTR_CALLNEXTWHENFALSE);
            if (node != null) {
                this.myIsInverted = Boolean.valueOf(node.getNodeValue());
            }
            if ((stqNode = attr.getNamedItem(ATTR_STQ)) != null) {
                this.mySTQualifier = SelectionTreeQualifier.valueOf(stqNode.getNodeValue());
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myIsInverted ? 1231 : 1237);
        result = 31 * result + (this.mySTQualifier == null ? 0 : this.mySTQualifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeStatement other = (NodeStatement)obj;
        if (this.myIsInverted != other.myIsInverted) {
            return false;
        }
        return !(this.mySTQualifier == null ? other.mySTQualifier != null : !this.mySTQualifier.equals(other.mySTQualifier));
    }

    protected boolean executeChild(ExecutableNode child, DataSet theData) {
        this.executeChildUsingExecutor(child, theData);
        TreeTask task = theData.getTreeTask();
        return !task.isDone() && !theData.shallExecutionStop();
    }

    @Override
    public void execute(DataSet theData) {
        this.executeImpl(theData);
    }

    protected void executeImpl(DataSet theData) {
        int j;
        TreeTask task;
        block11: {
            boolean isValid = false;
            task = theData.getTreeTask();
            task.saveState();
            if (this.myConditionArray != null) {
                for (int i = 0; i < this.myConditionArray.length; ++i) {
                    this.myConditionArray[i].enter(theData);
                }
            }
            while ((isValid = this.testConditions(theData)) && !this.myIsInverted || !isValid && this.myIsInverted) {
                task.resetModified();
                int nchld = this.myChildrenArray.length;
                boolean leftOK = true;
                for (int i = 0; i < nchld && this.executeChild(this.myChildrenArray[i], theData); ++i) {
                }
                if (this.myConditionArray != null) {
                    for (int j2 = this.myConditionArray.length - 1; j2 >= 0; --j2) {
                        leftOK = this.myConditionArray[j2].isReadyToLeave(theData) && leftOK;
                    }
                }
                boolean modified = task.isModified();
                if (!leftOK || modified && !task.isDone() && !theData.shallExecutionStop()) {
                    continue;
                }
                break block11;
            }
            if (this.myConditionArray != null) {
                for (j = this.myConditionArray.length - 1; j >= 0; --j) {
                    this.myConditionArray[j].isReadyToLeave(theData);
                }
            }
        }
        if (this.myConditionArray != null) {
            for (j = this.myConditionArray.length - 1; j >= 0; --j) {
                this.myConditionArray[j].leave(theData);
            }
        }
        task.restoreState();
    }

    private boolean testConditions(DataSet theData) {
        boolean isValid = false;
        if (this.myConditionArray != null && this.myConditionArray.length > 0) {
            int ncond = this.myConditionArray.length;
            for (int i = 0; i < ncond && !(isValid = this.testConditionUsingExecutor(this.myConditionArray[i], theData)); ++i) {
            }
        } else {
            isValid = true;
        }
        return isValid;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        if (this.myIsInverted) {
            return "== INVERTED ============================== [" + this.getName() + "]";
        }
        return "========================================== [" + this.getName() + "]";
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
    }

    public String toString() {
        String s = this.myName;
        if (this.myIsInverted) {
            s = s + " (inverted)";
        }
        return s;
    }

    @Override
    public boolean hasSelectionTreeQualifier() {
        return this.mySTQualifier != null;
    }

    @Override
    public SelectionTreeQualifier getSelectionTreeQualifier() {
        return this.mySTQualifier;
    }
}

