/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.structures;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.executor.TreeExecutorHelper;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.MutableTariffStructure;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatement;
import com.ericsson.ere.selectiontree.statements.NodeStatement;
import com.ericsson.ere.selectiontree.statements.Statement;
import com.ericsson.ere.selectiontree.structures.ImmutablePeriodTreeDescription;
import com.ericsson.ere.selectiontree.structures.PeriodTreeDescription;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TreeDefinedFieldBuilderFactory;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TreeDefinedFieldDefaultBuilderFactory;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeTariffStructure;
import ericsson.ere.RatingData;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructure;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.interfaces.UsedFieldLister;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import ericsson.ere.xml.XMLUtil;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTariffStructure
extends AbstractDAGNode
implements com.ericsson.ere.selectiontree.interfaces.TariffStructure,
MutableTariffStructure,
TariffStructureNode,
XMLInitializable,
TariffStructure,
UsedFieldLister {
    protected String myName;
    protected String myNodeId = null;
    protected AbstractNodeStatement myStatement = null;
    protected ClassRepository myRepository = null;
    protected boolean isInEuro;
    protected TreeDefinedFieldBuilderFactory myIVBuilderFactory;
    private boolean useInternalVars = false;
    protected ImmutablePeriodTreeDescription myPeriodTreeDescription;

    public AbstractTariffStructure() {
    }

    public AbstractTariffStructure(ClassRepository rep) {
        this.myRepository = rep;
    }

    @Override
    public ClassRepository getClassRepository() {
        return this.myRepository;
    }

    @Override
    public void setClassRepository(ClassRepository rep) {
        this.myRepository = rep;
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        Element versionElement;
        NamedNodeMap attr = iterator.getAttributes();
        if (attr == null) {
            throw new IllegalArgumentException("Attributes not found in TariffStructure");
        }
        Node node = attr.getNamedItem("id");
        if (node == null) {
            node = attr.getNamedItem("Id");
        }
        if (node != null) {
            this.myNodeId = node.getNodeValue();
        }
        if ((node = attr.getNamedItem("Name")) == null) {
            throw new IllegalArgumentException(EreDefs.getErrorString("error.noNameAttrInTariff"));
        }
        this.myName = node.getNodeValue();
        node = attr.getNamedItem("ServiceId");
        if (node == null) {
            throw new IllegalArgumentException(EreDefs.getErrorString("error.noServiceAttrInTariff"));
        }
        String serviceIdString = node.getNodeValue();
        node = attr.getNamedItem("TariffType");
        String tariffTypeStr = null;
        if (node != null) {
            tariffTypeStr = node.getNodeValue();
        }
        Element versionNode = XMLUtil.getNamedElement("Version", iterator.getChildNodes());
        ImmutablePeriodTreeDescription.ImmutablePeriodTreeVersion ptv = null;
        if (versionNode != null && (versionElement = versionNode).hasAttribute("id") && versionElement.hasAttribute("version") && versionElement.hasAttribute("created") && versionElement.hasAttribute("modified")) {
            String idStr = versionElement.getAttribute("id");
            Long version = null;
            try {
                version = Long.parseLong(versionElement.getAttribute("version"));
            }
            catch (NumberFormatException nfe) {
                throw new Exception(nfe);
            }
            String createDate = versionElement.getAttribute("created");
            String modifiedDate = versionElement.getAttribute("modified");
            ptv = ImmutablePeriodTreeDescription.createTariffVersion(idStr, version, createDate, modifiedDate);
        }
        this.myPeriodTreeDescription = new ImmutablePeriodTreeDescription(this.myName, this.myNodeId, serviceIdString, tariffTypeStr, ptv);
        Element fieldsElement = XMLUtil.getNamedElement("Fields", iterator.getChildNodes());
        if (this.useInternalVars) {
            this.myIVBuilderFactory = this.createTreeDefinedFieldFactory();
            this.myIVBuilderFactory.init(fieldsElement, this.myRepository);
        }
        return this;
    }

    @Override
    protected int hashCodeImpl() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isInEuro ? 1231 : 1237);
        result = 31 * result + (this.myIVBuilderFactory == null ? 0 : this.myIVBuilderFactory.hashCode());
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myNodeId == null ? 0 : this.myNodeId.hashCode());
        result = 31 * result + (this.myPeriodTreeDescription == null ? 0 : this.myPeriodTreeDescription.hashCode());
        result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.hashCode());
        result = 31 * result + (this.myStatement == null ? 0 : this.myStatement.hashCode());
        result = 31 * result + (this.useInternalVars ? 1231 : 1237);
        return result;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTariffStructure other = (AbstractTariffStructure)obj;
        if (this.isInEuro != other.isInEuro) {
            return false;
        }
        if (this.myIVBuilderFactory == null ? other.myIVBuilderFactory != null : !this.myIVBuilderFactory.equals(other.myIVBuilderFactory)) {
            return false;
        }
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        if (this.myNodeId == null ? other.myNodeId != null : !this.myNodeId.equals(other.myNodeId)) {
            return false;
        }
        if (this.myPeriodTreeDescription == null ? other.myPeriodTreeDescription != null : !this.myPeriodTreeDescription.equals(other.myPeriodTreeDescription)) {
            return false;
        }
        if (this.myRepository == null ? other.myRepository != null : !this.myRepository.equals(other.myRepository)) {
            return false;
        }
        if (this.myStatement == null ? other.myStatement != null : !this.myStatement.equals(other.myStatement)) {
            return false;
        }
        return this.useInternalVars == other.useInternalVars;
    }

    protected TreeDefinedFieldBuilderFactory createTreeDefinedFieldFactory() {
        return new TreeDefinedFieldDefaultBuilderFactory();
    }

    protected void checkCreateStatement() {
        if (this.myStatement == null) {
            String classname = this.myRepository.getNodeTypeClassName("Node");
            try {
                try {
                    this.initializeAndSetStatement((AbstractNodeStatement)EreClassLoader.createInstance(classname));
                }
                catch (InstantiationException e) {
                    this.initializeAndSetStatement(new NodeStatement());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("No Node found. Node statement must be declared", e);
            }
        }
    }

    private void initializeAndSetStatement(AbstractNodeStatement statement) {
        statement.setName(this.myName);
        if (this.myNodeId != null && !"".equals(this.myNodeId.trim())) {
            statement.setNodeId(this.myNodeId);
        }
        this.myStatement = statement;
    }

    protected String checkGetParam(String name, NodeList children, boolean mandatory) throws IllegalArgumentException {
        String text = null;
        Element node = XMLUtil.getNamedElement(name, children);
        if (node != null) {
            text = XMLUtil.getFirstTextContent(node);
            if (text == null) {
                throw new IllegalArgumentException("Empty element: " + name);
            }
        } else if (mandatory) {
            throw new IllegalArgumentException("Missing element: " + name);
        }
        return text;
    }

    public void add(ExecutableNode child) {
        this.checkCreateStatement();
        this.myStatement.addChildStatement(child);
        this.myStatement.buildFinished();
    }

    @Override
    public void add(Statement child) {
        this.add((ExecutableNode)child);
    }

    @Override
    public DAGNode getChildAt(int i) {
        this.checkCreateStatement();
        return this.myStatement.getChildAt(i);
    }

    @Override
    public int getChildCount() {
        this.checkCreateStatement();
        return this.myStatement.getChildCount();
    }

    @Override
    public void insertChildAt(int i, DAGNode n) {
        this.checkCreateStatement();
        this.myStatement.insertChildAt(i, n);
        this.myStatement.buildFinished();
    }

    @Override
    public void insertLinkAt(int i, DAGNode n) {
        this.checkCreateStatement();
        this.myStatement.insertLinkAt(i, n);
        this.myStatement.buildFinished();
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        this.checkCreateStatement();
        this.myStatement.replace(child, replacement);
    }

    @Override
    protected void removeChild(DAGNode n) {
        throw new IllegalArgumentException(EreDefs.getErrorString("error.nodeNotRemoved"));
    }

    @Override
    protected void removeLink(DAGNode n) {
        throw new IllegalArgumentException(EreDefs.getErrorString("error.nodeNotRemoved"));
    }

    @Override
    public int getNodeType() {
        return 0;
    }

    @Override
    public String getNodeId() {
        this.checkCreateStatement();
        return this.myStatement.getNodeId();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterTariffStructure(this);
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveTariffStructure(this);
    }

    @Override
    public final void add(ericsson.ere.statement.Statement child) throws Exception {
        this.add((Statement)child);
    }

    @Override
    public final void rate(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        throw new IllegalAccessException("Method not supported for this kind of structure");
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new TreeExecutionException(e);
        }
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        AbstractTariffStructure clone = (AbstractTariffStructure)this.clone();
        TraceNodeTariffStructure ts = new TraceNodeTariffStructure(clone);
        TariffStructureNode tni = this.myStatement.createTraceNode(0, ts);
        clone.myStatement = (AbstractNodeStatement)tni;
        return ts;
    }

    public String toString() {
        return this.myName;
    }

    public void useInternalVariables(boolean useIV) {
        this.useInternalVars = useIV;
    }

    public void createTDFFields(DataSet theData) {
        this.myIVBuilderFactory.createTreeDefinedField(theData);
    }

    @Deprecated
    public void addPeriodTreeDescritpion(DataSet theData) {
        this.registerPeriodTreeDescription(theData);
    }

    public void registerPeriodTreeDescription(DataSet theData) {
        theData.addPeriodTreeDescritpion(new PeriodTreeDescription(this.myPeriodTreeDescription));
    }

    protected final void executeUsingExecutor(DataSet dataSet) {
        TreeExecutorHelper.executeExecutableNode(this.myStatement, dataSet);
    }

    @Override
    public Set<String> getUsedFields() {
        return new HashSet<String>();
    }
}

