/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.structures;

import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.structure.AbstractTariffStructureTreeDefinedProfile;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultTreeStructureProfile
extends AbstractTariffStructureTreeDefinedProfile
implements ClassProfile {
    public static final String LBL_ID = "Id";
    public static final String LBL_NAME = "Name";
    public static final String LBL_COMMENT = "Comment";
    private static final String LBL_CREATED = "Created";
    private static final String LBL_SAVED = "Saved";
    private static final String LBL_SERVICEID = "Service Id";
    private static final String TAG_CREATED = "Created";
    private static final String TAG_SAVED = "Saved";
    private static final String ATTR_DATE = "Date";

    public DefaultTreeStructureProfile() {
        super(true);
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(6);
        BaseVariable var = new StringVariable(LBL_SERVICEID, "");
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Created", DateAndTimeVariable.Content.DATE_TIME);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Saved", DateAndTimeVariable.Content.DATE_TIME);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        l.addAll(super.getVariables());
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        Element savedElement;
        Element createdElement;
        NodeList children = iterator.getChildNodes();
        ArrayList<Variable> l = new ArrayList<Variable>();
        String created = "";
        String saved = "";
        Element versionElement = XMLUtil.getNamedElement("Version", children);
        if (versionElement != null) {
            created = versionElement.getAttribute("created");
            saved = versionElement.getAttribute("modified");
        }
        if (created.isEmpty() && (createdElement = XMLUtil.getNamedElement("Created", children)) != null) {
            created = createdElement.getAttribute(ATTR_DATE);
        }
        if (saved.isEmpty() && (savedElement = XMLUtil.getNamedElement("Saved", children)) != null) {
            saved = savedElement.getAttribute(ATTR_DATE);
        }
        List<Variable> superVars = super.getVariables(iterator);
        String service = VarListUtil.getValueStringForName(superVars, "Service");
        BaseVariable var = new StringVariable(LBL_SERVICEID, service);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Created", DateAndTimeVariable.Content.DATE_TIME, created);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Saved", DateAndTimeVariable.Content.DATE_TIME, saved);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        l.addAll(superVars);
        return l;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String service = VarListUtil.getValueStringForName(variables, "Service");
        String saved = VarListUtil.getTimeValueForName(variables, "Saved").toString();
        String info = "<b>" + this.getDescription(variables) + "</b>\nService: '" + service + "' - Saved: " + saved;
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public void printPreamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        ArrayList<Variable> patchedVars = new ArrayList<Variable>(variables);
        String service = VarListUtil.getValueStringForName(variables, LBL_SERVICEID);
        StringVariable var = new StringVariable("Service", service);
        VarListUtil.replaceVariableByLabel(patchedVars, "Service", var);
        super.printPreamble(out, indentLevel, indentMarker, patchedVars);
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
    }
}

