/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.structures.treedefinedfields;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TreeDefinedFieldAdditionalVar;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TreeDefinedFieldBuilderFactory;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TreeDefinedFieldValue;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.xml.XMLUtil;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTreeDefinedFieldMetaBuilderFactory
implements TreeDefinedFieldBuilderFactory {
    @Override
    public void init(Element fields, ClassRepository repository) {
        if (fields != null) {
            NodeList fieldsList = fields.getChildNodes();
            for (int i = 0; i < fieldsList.getLength(); ++i) {
                if (fieldsList.item(i).getNodeType() != 1) continue;
                Element field = (Element)fieldsList.item(i);
                String nameAttr = XMLUtil.getAttributeFromElement(field, "Name", null);
                String dataTypeAttr = XMLUtil.getAttributeFromElement(field, "DataType", null);
                String defaultAttr = XMLUtil.getAttributeFromElement(field, "Default", null);
                TreeDefinedFieldValue treeDefinedFieldValue = new TreeDefinedFieldValue(repository, nameAttr, dataTypeAttr, defaultAttr);
                if (XMLUtil.getAttributeFromElement(field, "ParameterType", null).equals("INTERNAL")) {
                    this.addFieldToRepository(repository, nameAttr, field);
                }
                HashMap<String, TreeDefinedFieldAdditionalVar> vars = new HashMap<String, TreeDefinedFieldAdditionalVar>();
                Element additional = XMLUtil.getFirstElementNamed("Additional", field);
                if (additional != null) {
                    NodeList varList = additional.getChildNodes();
                    for (int j = 0; j < varList.getLength(); ++j) {
                        Node item = varList.item(j);
                        if (item.getNodeType() != 1) continue;
                        Element varElement = (Element)item;
                        if (!item.getNodeName().equals("AdditionalVar")) continue;
                        String varNameAttr = XMLUtil.getAttributeFromElement(varElement, "Name", null);
                        String varDataTypeAttr = XMLUtil.getAttributeFromElement(varElement, "DataType", null);
                        String varValueAttr = XMLUtil.getAttributeFromElement(varElement, "Value", null);
                        TreeDefinedFieldAdditionalVar var = new TreeDefinedFieldAdditionalVar(varNameAttr, varDataTypeAttr, varValueAttr);
                        vars.put(varNameAttr, var);
                    }
                }
                this.initTreeDefinedField(treeDefinedFieldValue, vars);
            }
        }
    }

    protected void addFieldToRepository(ClassRepository repository, String name, Element fieldElement) {
        if (repository.getFieldDefinitionByName(name) == null) {
            repository.addField(fieldElement);
        }
    }

    protected abstract void initTreeDefinedField(TreeDefinedFieldValue var1, HashMap<String, TreeDefinedFieldAdditionalVar> var2);

    @Override
    public void createTreeDefinedField(DataSet dataset) {
    }
}

