/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.structures.treedefinedfields;

import ericsson.ere.datatype.DataType;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class TDFAdditionalDataType {
    public static final TDFAdditionalDataType AMOUNT = new TDFAdditionalDataType(DataType.AMOUNT, EnumSet.noneOf(InputRestriction.class), "Amount");
    public static final TDFAdditionalDataType DATE = new TDFAdditionalDataType(DataType.DATE, EnumSet.noneOf(InputRestriction.class), "Date");
    public static final TDFAdditionalDataType TIME = new TDFAdditionalDataType(DataType.TIME, EnumSet.noneOf(InputRestriction.class), "Time");
    public static final TDFAdditionalDataType RATINGDECIMAL = new TDFAdditionalDataType(DataType.RATINGDECIMAL, EnumSet.of(InputRestriction.ENUMERATION), "Floating-point number");
    public static final TDFAdditionalDataType LONG = new TDFAdditionalDataType(DataType.LONG, EnumSet.of(InputRestriction.ENUMERATION, InputRestriction.RANGE), "Number");
    public static final TDFAdditionalDataType STRING = new TDFAdditionalDataType(DataType.STRING, EnumSet.of(InputRestriction.ENUMERATION), "Text");
    public static final TDFAdditionalDataType BOOLEAN = new TDFAdditionalDataType(DataType.BOOLEAN, EnumSet.of(InputRestriction.ENUMERATION), "Boolean");
    private static final List<TDFAdditionalDataType> ALL = Arrays.asList(AMOUNT, DATE, TIME, LONG, STRING, BOOLEAN, RATINGDECIMAL);
    private DataType myNativeDataType = null;
    private EnumSet<InputRestriction> myInputRestrictions = null;
    private String myTypeDescription;

    @Deprecated
    public TDFAdditionalDataType() {
        this.initFrom(AMOUNT);
    }

    private void initFrom(TDFAdditionalDataType source) {
        this.myNativeDataType = source.myNativeDataType;
        this.myInputRestrictions = source.myInputRestrictions;
        this.myTypeDescription = source.myTypeDescription;
    }

    protected TDFAdditionalDataType(DataType dataType, EnumSet<InputRestriction> inputRestrictions, String description) {
        this.myTypeDescription = description;
        this.myInputRestrictions = inputRestrictions;
        this.myNativeDataType = dataType;
    }

    @Deprecated
    public TDFAdditionalDataType(String dataType) {
        if (dataType.equals("Amount")) {
            this.initFrom(AMOUNT);
        } else if (dataType.equals("Date")) {
            this.initFrom(DATE);
        } else if (dataType.equals("Time")) {
            this.initFrom(TIME);
        } else {
            throw new IllegalArgumentException("Data type '" + dataType + "' is not supported by this constructor.");
        }
    }

    public String getDataType() {
        return this.myNativeDataType.getTypeName();
    }

    public String[] getInputRestrictionsAllowed() {
        String[] ret = new String[this.myInputRestrictions.size() + 1];
        ret[0] = "NO DATA";
        int i = 1;
        for (InputRestriction ir : this.myInputRestrictions) {
            ret[i++] = ir.toString();
        }
        return ret;
    }

    public boolean isRangeAllowed() {
        return this.myInputRestrictions.contains((Object)InputRestriction.RANGE);
    }

    public boolean isEnumAllowed() {
        return this.myInputRestrictions.contains((Object)InputRestriction.ENUMERATION);
    }

    public DataType getNativeDataType() {
        return this.myNativeDataType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myNativeDataType == null ? 0 : this.myNativeDataType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TDFAdditionalDataType other = (TDFAdditionalDataType)obj;
        return !(this.myNativeDataType == null ? other.myNativeDataType != null : !this.myNativeDataType.equals(other.myNativeDataType));
    }

    public String getTypeDescription() {
        return this.myTypeDescription;
    }

    public static TDFAdditionalDataType getByDataType(String dataTypeName) {
        return TDFAdditionalDataType.getByDataType(DataType.lookup(dataTypeName));
    }

    public static TDFAdditionalDataType getByDataType(DataType dataType) {
        return TDFAdditionalDataType.getByDataTypeFromList(dataType, ALL);
    }

    public static TDFAdditionalDataType getByDataTypeFromList(DataType dataType, List<TDFAdditionalDataType> dataTypeList) {
        TDFAdditionalDataType found = null;
        for (TDFAdditionalDataType additionalDataType : dataTypeList) {
            if (additionalDataType.getNativeDataType() != dataType) continue;
            found = additionalDataType;
            break;
        }
        return found;
    }

    public static TDFAdditionalDataType getByDescription(String desc) {
        TDFAdditionalDataType ret = null;
        for (TDFAdditionalDataType dt : ALL) {
            String s = dt.getTypeDescription();
            if (!s.equalsIgnoreCase(desc)) continue;
            ret = dt;
            break;
        }
        return ret;
    }

    public String toString() {
        return this.myTypeDescription + " (" + this.myNativeDataType.getTypeName() + ")";
    }

    public static enum InputRestriction {
        ENUMERATION,
        RANGE;

    }
}

