/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.structures.treedefinedfields;

import ericsson.ere.datatype.ContextBasedValueResolver;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import java.text.ParseException;

public class TreeDefinedFieldValue {
    private String myName;
    private DataType myDataType;
    private String myValue;
    private ClassRepository myClassRepository;

    public TreeDefinedFieldValue(ClassRepository repository, String name, String datatype, String value) {
        this.myName = name;
        this.myDataType = DataType.lookup(datatype);
        this.myValue = value;
        this.myClassRepository = repository;
    }

    @Deprecated
    public TreeDefinedFieldValue(String name, String datatype, String value) {
        this(null, name, datatype, value);
    }

    public String getName() {
        return this.myName;
    }

    public String getDataType() {
        return this.myDataType == null ? null : this.myDataType.getTypeName();
    }

    public String getValue() {
        return this.myValue;
    }

    public Object createValueObject() {
        if (this.myDataType == null) {
            return null;
        }
        ContextBasedValueResolver resolver = this.myDataType.createContextBasedValueResolver();
        if (this.myClassRepository != null) {
            resolver.withClassRepository(this.myClassRepository);
        }
        if (this.myValue == null) {
            return resolver.createDefaultValue();
        }
        return TreeDefinedFieldValue.createValueFromString(resolver, this.myValue);
    }

    private static Object createValueFromString(ContextBasedValueResolver resolver, String valueStr) {
        try {
            return resolver.parseString(valueStr);
        }
        catch (ParseException ex) {
            return null;
        }
    }
}

