/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfexport.panels;

import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.selectiontree.tdfexport.panels.TDFExportProgressView;
import ericsson.ere.gui.util.InformationPane;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressIndicatorHandler;
import ericsson.ere.progress.ProgressVisualizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class TDFExportProgressPanel
extends AbstractWizardPanel
implements ProgressVisualizer,
TDFExportProgressView {
    private InformationPane myAdditionalInfo;
    private JProgressBar myProgressBar;

    public TDFExportProgressPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints progressBarConstraints = new GridBagConstraints();
        progressBarConstraints.gridx = 0;
        progressBarConstraints.insets = new Insets(0, 12, 17, 12);
        progressBarConstraints.fill = 2;
        progressBarConstraints.gridy = 1;
        GridBagConstraints scrollPaneConstraints = new GridBagConstraints();
        scrollPaneConstraints.fill = 1;
        scrollPaneConstraints.gridx = 0;
        scrollPaneConstraints.gridy = 0;
        scrollPaneConstraints.weightx = 1.0;
        scrollPaneConstraints.weighty = 1.0;
        scrollPaneConstraints.insets = new Insets(12, 12, 11, 12);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(435, 357));
        this.add((Component)this.createContentScrollPane(), scrollPaneConstraints);
        this.add((Component)this.createProgressBar(), progressBarConstraints);
    }

    @Override
    public String getPanelDescription() {
        return "Exporting the selected TDF to file.";
    }

    @Override
    public String getPanelIdentifier() {
        return "TDFExportProgressPanel";
    }

    @Override
    public void wizardCanceled() {
    }

    @Override
    public void setInfoText(String text) {
        this.myAdditionalInfo.addInformation(text, Color.BLACK, 0);
    }

    @Override
    public void setProgressGoal(int goal) {
        this.myProgressBar.setMinimum(0);
        this.myProgressBar.setMaximum(goal);
    }

    @Override
    public void setValue(int value) {
        this.myProgressBar.setValue(value);
    }

    @Override
    public void showAdditionalInfo(String text) {
        this.myAdditionalInfo.addInformation(text, Color.RED, 0);
    }

    public ProgressIndicator getProgressIndicator() {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(this);
        return handler.getProgressIndicator();
    }

    public ProgressIndicator getProgressIndicator(int goal) {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(goal, this);
        return handler.getProgressIndicator();
    }

    private JScrollPane createContentScrollPane() {
        JScrollPane contentPane = new JScrollPane();
        this.myAdditionalInfo = new InformationPane();
        this.myAdditionalInfo.setLineWrap(true);
        contentPane.getViewport().add(this.myAdditionalInfo);
        return contentPane;
    }

    private JProgressBar createProgressBar() {
        this.myProgressBar = new JProgressBar();
        this.myProgressBar.setStringPainted(true);
        return this.myProgressBar;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled();
    }

    @Override
    public void setConfirmBeforeExit() {
    }

    @Override
    public void handleError(Exception e, String text) {
        ExceptionUtil.handleException(e, "export", 1, text, true);
    }
}

