/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfimport.panels;

import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.gui.wizard.selectabletable.SelectableTableModel;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableNodeWrapper;
import com.ericsson.ere.selectiontree.tdfimport.TDFImportWizardModel;
import com.ericsson.ere.selectiontree.tdfimport.panels.TDFImportFieldsView;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class TDFImportFieldsPanel
extends AbstractWizardPanel
implements TDFImportFieldsView {
    private JScrollPane myFieldsTableScroller;
    private JTable myFieldsTable;
    private JButton mySelectAllBtn;
    private JButton myClearAllSelectionsBtn;
    private TDFImportWizardModel myModel;
    private SelectableTableModel myItemsTableModel;

    public TDFImportFieldsPanel(TDFImportWizardModel model) {
        this.myModel = model;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints clearAllBtnConstraints = new GridBagConstraints();
        clearAllBtnConstraints.gridx = 1;
        clearAllBtnConstraints.anchor = 16;
        clearAllBtnConstraints.insets = new Insets(11, 4, 0, 0);
        clearAllBtnConstraints.gridy = 0;
        GridBagConstraints selectAllBtnConstraints = new GridBagConstraints();
        selectAllBtnConstraints.gridx = 0;
        selectAllBtnConstraints.insets = new Insets(17, 11, 0, 0);
        selectAllBtnConstraints.gridy = 0;
        GridBagConstraints fieldsScrollerConstraints = new GridBagConstraints();
        fieldsScrollerConstraints.fill = 1;
        fieldsScrollerConstraints.gridx = 0;
        fieldsScrollerConstraints.gridy = 2;
        fieldsScrollerConstraints.weightx = 1.0;
        fieldsScrollerConstraints.weighty = 1.0;
        fieldsScrollerConstraints.gridwidth = 2;
        fieldsScrollerConstraints.insets = new Insets(6, 11, 11, 11);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(418, 353));
        this.add((Component)this.createFieldsScrollPane(), fieldsScrollerConstraints);
        this.add((Component)this.createSelectAllButton(), selectAllBtnConstraints);
        this.add((Component)this.createClearAllSelectionsButton(), clearAllBtnConstraints);
    }

    @Override
    public String getPanelIdentifier() {
        return "ImportFieldSelection";
    }

    @Override
    public String getPanelDescription() {
        return "Select the TDF(s) that you want to import.";
    }

    @Override
    public void wizardCanceled() {
        this.myModel.clearResultingTDFs();
    }

    @Override
    public void prepareModel() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                TDFImportFieldsPanel.this.myItemsTableModel = new SelectableTableModel(new Vector<Object>(TDFImportFieldsPanel.this.myModel.getTDFNames()));
                TDFImportFieldsPanel.this.myFieldsTable.setModel(TDFImportFieldsPanel.this.myItemsTableModel);
                TDFImportFieldsPanel.this.myFieldsTable.getColumnModel().getColumn(0).setMaxWidth(50);
            }
        });
    }

    private JScrollPane createFieldsScrollPane() {
        this.myFieldsTableScroller = new JScrollPane();
        this.myFieldsTableScroller.setViewportView(this.createFieldsTable());
        return this.myFieldsTableScroller;
    }

    private JTable createFieldsTable() {
        this.myFieldsTable = new JTable();
        this.myFieldsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TDFImportFieldsPanel.this.myFieldsTable.repaint();
                TDFImportFieldsPanel.this.triggerObservers();
            }
        });
        this.myFieldsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                if (k.getKeyCode() != 32) {
                    return;
                }
                int[] comp = TDFImportFieldsPanel.this.myFieldsTable.getSelectedRows();
                if (comp instanceof SelectableNodeWrapper) {
                    TDFImportFieldsPanel.this.myFieldsTable.repaint();
                    TDFImportFieldsPanel.this.triggerObservers();
                }
            }
        });
        return this.myFieldsTable;
    }

    private JButton createSelectAllButton() {
        this.mySelectAllBtn = new JButton();
        this.mySelectAllBtn.setToolTipText("Select all");
        this.mySelectAllBtn.setPreferredSize(new Dimension(20, 20));
        this.mySelectAllBtn.setMinimumSize(new Dimension(20, 20));
        this.mySelectAllBtn.setIcon(RmaDefs.getImageIcon("MultiSelect16.gif"));
        this.mySelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TDFImportFieldsPanel.this.myItemsTableModel.markAllForExport(true);
                TDFImportFieldsPanel.this.myFieldsTable.repaint();
                TDFImportFieldsPanel.this.triggerObservers();
            }
        });
        return this.mySelectAllBtn;
    }

    private JButton createClearAllSelectionsButton() {
        this.myClearAllSelectionsBtn = new JButton();
        this.myClearAllSelectionsBtn.setToolTipText("Clear all");
        this.myClearAllSelectionsBtn.setPreferredSize(new Dimension(20, 20));
        this.myClearAllSelectionsBtn.setMinimumSize(new Dimension(20, 20));
        this.myClearAllSelectionsBtn.setIcon(RmaDefs.getImageIcon("MultiDeSelect16.gif"));
        this.myClearAllSelectionsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TDFImportFieldsPanel.this.myItemsTableModel.markAllForExport(false);
                TDFImportFieldsPanel.this.myFieldsTable.repaint();
                TDFImportFieldsPanel.this.triggerObservers();
            }
        });
        return this.myClearAllSelectionsBtn;
    }

    @Override
    public boolean hasSelections() {
        return this.myItemsTableModel.hasSelectedItems();
    }

    @Override
    public List<String> getSelectedTDFs() {
        ArrayList<String> selectedTDFs = new ArrayList<String>();
        for (int i = 0; i < this.myItemsTableModel.getRowCount(); ++i) {
            boolean isSelected = (Boolean)this.myItemsTableModel.getValueAt(i, 0);
            String tdfName = (String)this.myItemsTableModel.getValueAt(i, 1);
            if (!isSelected) continue;
            selectedTDFs.add(tdfName);
        }
        return selectedTDFs;
    }

    @Override
    public boolean shouldOverwriteUsedTDF(String name) {
        DialogFactory.getInformationDialog(this, "Field already in use", "<html>The field <strong>\"" + name + "\"</strong> is used in the tree.<br> You have to modify this field manually.</html>");
        return false;
    }

    @Override
    public boolean shouldOverwriteExistingTDF(String name) {
        return DialogFactory.getQuestionDialog(this, "Field already exists", "<html>The field <strong>\"" + name + "\"</strong> already exists.<br> Would you like to overwrite this field?</html>");
    }

    @Override
    public void removeSelectionFor(final String name) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                int row = TDFImportFieldsPanel.this.myItemsTableModel.getRowForItem(name);
                TDFImportFieldsPanel.this.myItemsTableModel.setValueAt(false, row, 0);
            }
        });
    }

    @Override
    public void notifyUserFieldIsDefinedInService(String name) {
        DialogFactory.getInformationDialog(this, "Field already defined in service", "<html>The field <strong>\"" + name + "\"</strong> is defined in the service and cannot be imported.</html>");
    }
}

