/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfimport.panels;

import com.ericsson.ere.gui.navigator.NavigatorFileChooser;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.selectiontree.tdfimport.panels.TDFImportFileView;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class TDFImportFilePanel
extends AbstractWizardPanel
implements TDFImportFileView {
    private JTextField myFieldNameField = null;
    private JButton myFileBrowseBtn = null;
    private JLabel myFileLabel = null;

    public TDFImportFilePanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 1;
        labelConstraints.anchor = 16;
        labelConstraints.insets = new Insets(17, 11, 0, 0);
        labelConstraints.gridy = 0;
        this.myFileLabel = new JLabel();
        this.myFileLabel.setText("Import file:");
        GridBagConstraints browseBtnConstraint = new GridBagConstraints();
        browseBtnConstraint.insets = new Insets(6, 3, 10, 12);
        browseBtnConstraint.gridy = 1;
        browseBtnConstraint.anchor = 11;
        browseBtnConstraint.weighty = 1.0;
        browseBtnConstraint.gridx = 2;
        GridBagConstraints fileNameFieldConstraints = new GridBagConstraints();
        fileNameFieldConstraints.fill = 2;
        fileNameFieldConstraints.gridx = 1;
        fileNameFieldConstraints.gridy = 1;
        fileNameFieldConstraints.weightx = 1.0;
        fileNameFieldConstraints.anchor = 11;
        fileNameFieldConstraints.weighty = 1.0;
        fileNameFieldConstraints.insets = new Insets(6, 11, 5, 2);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(443, 268));
        this.add((Component)this.createFileNameField(), fileNameFieldConstraints);
        this.add((Component)this.createSelectFileButton(), browseBtnConstraint);
        this.add((Component)this.myFileLabel, labelConstraints);
    }

    private JTextField createFileNameField() {
        this.myFieldNameField = new JTextField();
        this.myFieldNameField.setPreferredSize(new Dimension(4, 27));
        this.myFieldNameField.setEnabled(false);
        return this.myFieldNameField;
    }

    private JButton createSelectFileButton() {
        this.myFileBrowseBtn = new JButton();
        this.myFileBrowseBtn.setText("Browse");
        this.myFileBrowseBtn.setName("TDFImportFilePanel.JButton.browseButton");
        this.myFileBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File fileToImport = NavigatorFileChooser.getImportFile("Import TDF from file");
                if (fileToImport != null) {
                    TDFImportFilePanel.this.myFieldNameField.setText(fileToImport.getAbsolutePath());
                } else {
                    TDFImportFilePanel.this.myFieldNameField.setText("");
                }
                TDFImportFilePanel.this.triggerObservers(fileToImport);
            }
        });
        return this.myFileBrowseBtn;
    }

    @Override
    public String getPanelDescription() {
        return "Select the file to import.";
    }

    @Override
    public String getPanelIdentifier() {
        return "TDF_FilePanel";
    }

    @Override
    public void wizardCanceled() {
    }

    @Override
    public void handleError(Exception e, String text) {
        ExceptionUtil.handleException(e, "import", 1, text, true);
    }

    @Override
    public void showInformation(String header, String text) {
        DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), header, text);
    }
}

