/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.conditions.util.EnumParser;
import com.ericsson.ere.selectiontree.util.FieldIndexFormatter;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.MultipleValueFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.UsedFieldLister;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class FieldOrientedPluginUtil {
    public static FieldIndexKeyContainer.KeyType getKeyTypeForField(String fieldName, ClassRepository repository) {
        FieldHierarchyNode field = repository.getFieldRepository().getFieldByName(fieldName);
        return FieldOrientedPluginUtil.getKeyTypeForField(field);
    }

    public static FieldIndexKeyContainer.KeyType getKeyTypeForField(FieldHierarchyNode field) {
        FieldIndexKeyContainer.KeyType retVal = null;
        if (field != null) {
            FieldHierarchyNode.ComplexType complexType;
            FieldStructure parent = field.getParent();
            FieldHierarchyNode.ComplexType parentType = null;
            if (parent != null) {
                parentType = parent.getComplexType();
            }
            if ((complexType = field.getComplexType()) == FieldHierarchyNode.ComplexType.ARRAY || parentType == FieldHierarchyNode.ComplexType.ARRAY) {
                retVal = FieldIndexKeyContainer.KeyType.VALUE_LIST;
            } else if (complexType == FieldHierarchyNode.ComplexType.MAP || complexType == FieldHierarchyNode.ComplexType.SET || parentType == FieldHierarchyNode.ComplexType.MAP) {
                retVal = FieldIndexKeyContainer.KeyType.VALUE_MAP;
            }
        }
        return retVal;
    }

    public static Key extractFirstKeyFromSet(Key[] keys) {
        if (keys != null && keys.length > 0) {
            return keys[0];
        }
        return null;
    }

    public static FieldIndexKeyContainer extractIndexKeyObjectFromIndexElement(Element indexElement, FieldIndexKeyContainer.KeyType keyType, ClassRepository repository) {
        return FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(indexElement, keyType, repository, null);
    }

    public static FieldIndexKeyContainer extractIndexKeyObjectFromIndexElement(Element indexElement, ClassRepository repository, FieldHierarchyNode indexedField) {
        if (indexedField == null) {
            return null;
        }
        return FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(indexElement, null, repository, indexedField);
    }

    public static FieldIndexKeyContainer extractIndexKeyObjectFromIndexElement(ValueFieldCompositeObject indexObject, ClassRepository repository, FieldDefinition indexedField) {
        FieldIndexKeyContainer.KeyType ktype = FieldOrientedPluginUtil.getKeyTypeForField(indexedField);
        if (ktype != null) {
            FieldDefinition[] keyFields = FieldOrientedPluginUtil.deduceKeyFieldArray(repository, indexedField);
            return new FieldIndexKeyContainer(indexObject, ktype, repository, keyFields);
        }
        return null;
    }

    private static FieldIndexKeyContainer extractIndexKeyObjectFromIndexElement(Element indexElement, FieldIndexKeyContainer.KeyType keyType, ClassRepository repository, FieldHierarchyNode indexedField) {
        FieldIndexKeyContainer.KeyType ktype = keyType;
        if (ktype == null) {
            ktype = FieldOrientedPluginUtil.getKeyTypeForField(indexedField);
        }
        if (indexElement != null && ktype != null) {
            ValueFieldCompositeObject indexObject;
            Element valueElement = XMLUtil.getNamedElement("Value", indexElement.getChildNodes());
            if (valueElement == null) {
                valueElement = XMLUtil.getNamedElement("Complex", indexElement.getChildNodes());
                indexObject = new MultipleValueFieldCompositeObject(valueElement);
            } else {
                indexObject = new ValueFieldCompositeObject(valueElement);
            }
            FieldDefinition[] fieldArray = FieldOrientedPluginUtil.deduceKeyFieldArray(repository, indexedField);
            return new FieldIndexKeyContainer(indexObject, ktype, repository, fieldArray);
        }
        return null;
    }

    private static FieldDefinition[] deduceKeyFieldArray(ClassRepository rep, FieldHierarchyNode indexedField) {
        List<FieldDefinition> keyFields = FieldOrientedPluginUtil.extractKeyFields(indexedField, rep);
        if (keyFields.size() > 0) {
            return keyFields.toArray(new FieldDefinition[keyFields.size()]);
        }
        return null;
    }

    public static String formatFieldNameWithKeyInformation(String fieldName, FieldIndexKeyContainer fieldKeyContainer, DataSet theData) {
        String ret;
        try {
            FieldIndexFormatter formatter = new FieldIndexFormatter(fieldName);
            ret = formatter.format(fieldKeyContainer, theData);
        }
        catch (DataSetValueNotFoundException e) {
            String keyFieldName = fieldKeyContainer.getKeyFieldName();
            String valueString = keyFieldName != null ? keyFieldName : "VALUE NOT FOUND";
            ret = fieldName + "[" + valueString + "]";
        }
        return ret;
    }

    @Deprecated
    public static String formatFieldNameWithKeyInformation(String fieldName, Key key, String keyFieldName) {
        return FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(fieldName, key, keyFieldName, null);
    }

    public static String formatFieldNameWithKeyInformation(String fieldName, Key key, String keyFieldName, DataSet theData) {
        FieldIndexFormatter formatter = new FieldIndexFormatter(fieldName);
        return formatter.format(key, keyFieldName, theData);
    }

    public static String getEnumLabelOrToStringValue(Object value, FieldDefinition fd) {
        String returnValue = "";
        if (value != null) {
            Map<String, String> enumStringMap;
            Map<Object, String> enumMap;
            returnValue = fd != null ? ((enumMap = EnumParser.extractValueEnumMap(fd)) != null ? (enumMap.get(value) == null ? ((enumStringMap = EnumParser.extractEnumMap(fd)) != null && enumStringMap.get(value.toString()) != null ? enumStringMap.get(value.toString()) : value.toString()) : enumMap.get(value)) : value.toString()) : value.toString();
        }
        return returnValue;
    }

    public static String getEnumLabelOrEmptyString(Object value, FieldDefinition associatedField) {
        String result = "";
        String text = FieldOrientedPluginUtil.getEnumLabelOrToStringValue(value, associatedField);
        if (value != null && !text.equals(value.toString())) {
            result = text;
        }
        return result;
    }

    public static String describeFieldValue(FieldDefinition associatedField, String valueString) {
        DataType dt = associatedField.getTypedDataType();
        Object valueObject = dt.parseValue(valueString);
        return new DefaultDataDescriber().describeObject(valueObject, associatedField);
    }

    public static ValueFieldCompositeObject createValueFieldCompositeObjectFromIndexElement(Element indexElement) {
        if (indexElement == null) {
            return null;
        }
        Element complexElement = XMLUtil.getFirstElementNamed("Complex", indexElement);
        if (complexElement != null) {
            return new MultipleValueFieldCompositeObject(complexElement);
        }
        return new ValueFieldCompositeObject(XMLUtil.getFirstElementNamed("Value", indexElement));
    }

    public static ValueFieldCompositeObject createDefaultValueFieldCompositeObjectForFieldKey(FieldDefinition field, ClassRepository repository) {
        List<FieldDefinition> keyFields = FieldOrientedPluginUtil.extractKeyFields(field, repository);
        ValueFieldCompositeObject vfco = null;
        if (keyFields.size() == 1) {
            vfco = FieldOrientedPluginUtil.createDefaultValueForField(keyFields.get(0));
        } else if (keyFields.size() > 1) {
            vfco = new MultipleValueFieldCompositeObject(keyFields, repository);
        } else if (field != null && keyFields.size() < 1) {
            DataType dataType = field.getTypedDataType();
            Object obj = dataType.createDefaultInstance();
            vfco = ValueFieldCompositeObject.createForValue(dataType.makeParseableString(obj), dataType);
        } else if (field != null && field.isArray()) {
            vfco = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Value, "0");
        }
        return vfco;
    }

    public static ValueFieldCompositeObject createDefaultValueForField(FieldDefinition fieldDefinition) {
        ValueResolver resolver = DataType.createTypeIndependentContextBasedValueResolver().withFieldDefinition(fieldDefinition).disableLazyEvaluatedValuePreference().finish();
        String str = resolver.makeValueString(resolver.createDefaultInstance());
        return ValueFieldCompositeObject.createForValue(str, resolver);
    }

    public static List<FieldDefinition> extractKeyFields(FieldHierarchyNode field, ClassRepository repository) {
        if (field == null) {
            return Collections.emptyList();
        }
        if (repository == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        List<Object> keyFields = new ArrayList();
        if (field.isLeaf()) {
            if (field.getComplexType() == FieldHierarchyNode.ComplexType.MAP) {
                String[] keyNames;
                FieldDefinition leaf = (FieldDefinition)field;
                for (String keyName : keyNames = leaf.getKeyFields()) {
                    FieldDefinition currentKeyField = (FieldDefinition)repository.getFieldRepository().getFieldByName(XMLUtil.unEscape(keyName));
                    if (currentKeyField == null) continue;
                    keyFields.add(currentKeyField);
                }
            } else if (field.getParent() != null) {
                FieldStructure parent = field.getParent();
                keyFields = parent.getKeyFields();
            }
        } else {
            keyFields = ((FieldStructure)field).getKeyFields();
        }
        return keyFields;
    }

    public static void checkMissingFields(UsedFieldLister lister, ClassRepository rep) {
        Set<String> usedFields = lister.getUsedFields();
        HashSet<String> missingFields = new HashSet<String>();
        for (String usedField : usedFields) {
            if (StringUtil.isEmptyString(usedField) || rep.getFieldRepository().getFieldByName(usedField) != null) continue;
            missingFields.add(usedField);
        }
        if (!missingFields.isEmpty()) {
            throw new PluginCreationException("Referenced field(s) missing : " + StringUtil.join(missingFields.toArray(), ","));
        }
    }
}

