/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.UsedFieldLister;
import java.util.HashSet;
import java.util.Set;

@Immutable
public final class FieldValueContainer
implements UsedFieldLister {
    private final Object myValue;
    private final DataSetField myField;
    private final FieldIndexKeyContainer myKeyIndex;

    public FieldValueContainer(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter value must not be null.");
        }
        this.myValue = value;
        this.myField = null;
        this.myKeyIndex = null;
    }

    public FieldValueContainer(FieldDefinition field, FieldIndexKeyContainer keyIndex, DataType desiredDataType) {
        if (field == null) {
            throw new IllegalArgumentException("Parameter field must not be null.");
        }
        DataType dataType = desiredDataType != null ? desiredDataType : field.getTypedDataType();
        this.myField = new DataSetField(field.getFieldName(), field.getTagNumber(), field.usesTagNumber(), dataType, field.isComplexType());
        this.myKeyIndex = keyIndex;
        this.myValue = null;
    }

    public boolean containsValue() {
        return this.myValue != null;
    }

    public Object getValue(DataSet dataSet) {
        if (this.myValue != null) {
            return this.myValue;
        }
        if (dataSet == null) {
            throw new IllegalArgumentException("Parameter dataSet must not be null when field is contained.");
        }
        Key[] keySet = this.myKeyIndex != null ? this.myKeyIndex.getKeySet(dataSet) : null;
        return this.myField.getValueFromDataSet(dataSet, FieldOrientedPluginUtil.extractFirstKeyFromSet(keySet));
    }

    public void addAsPreDataInTracePoint(TracePoint tp) {
        if (this.myField != null) {
            PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
        }
    }

    public String getFieldDisplayString(DataSet dataSet) {
        String fieldStr = "";
        if (this.myField != null) {
            fieldStr = FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(this.myField.getFieldName(), this.myKeyIndex, dataSet);
        }
        return fieldStr;
    }

    @Override
    public Set<String> getUsedFields() {
        HashSet<String> usedFields = new HashSet<String>();
        if (this.myField != null) {
            usedFields.add(this.myField.getFieldName());
            if (this.myKeyIndex != null) {
                usedFields.addAll(this.myKeyIndex.getUsedFields());
            }
        }
        return usedFields;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myField == null ? 0 : this.myField.hashCode());
        result = 31 * result + (this.myKeyIndex == null ? 0 : this.myKeyIndex.hashCode());
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldValueContainer other = (FieldValueContainer)obj;
        if (this.myField == null ? other.myField != null : !this.myField.equals(other.myField)) {
            return false;
        }
        if (this.myKeyIndex == null ? other.myKeyIndex != null : !this.myKeyIndex.equals(other.myKeyIndex)) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }
}

