/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.selectiontree.interfaces.MetaDataHolder;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;

public final class SelectionTreeUtil {
    private static final Object PATH_TO_ROOT_KEY = new Object();

    private SelectionTreeUtil() {
    }

    public static String getPathToRoot(TariffStructureNode element) {
        String strPath;
        boolean cache = element instanceof MetaDataHolder;
        if (cache && (strPath = SelectionTreeUtil.getElementData(element, PATH_TO_ROOT_KEY, String.class)) != null) {
            return strPath;
        }
        TreePath path = DAGUtil.getPathToRoot(element);
        strPath = DAGUtil.getTreePathToString(path);
        if (cache) {
            SelectionTreeUtil.setElementData(element, PATH_TO_ROOT_KEY, strPath);
        }
        return strPath;
    }

    public static Element getElementConfiguration(TariffStructureNode e) {
        Element config = SelectionTreeUtil.getElementData(e, MetaDataHolder.CONFIG_NODE_KEY, Element.class);
        return config;
    }

    public static <T> T getElementData(TariffStructureNode elem, Object key, Class<T> dataClass) {
        SelectionTreeUtil.checkType(elem);
        Object o = ((MetaDataHolder)((Object)elem)).getElementData(key);
        return (T)o;
    }

    public static <T> T getElementData(TariffStructureNode elem, Class<T> dataClass) {
        return SelectionTreeUtil.getElementData(elem, dataClass, dataClass);
    }

    public static <T> void setElementData(TariffStructureNode elem, Class<T> dataClass, T data) {
        SelectionTreeUtil.checkType(elem);
        ((MetaDataHolder)((Object)elem)).setElementData(dataClass, data);
    }

    public static void setElementData(TariffStructureNode elem, Object key, Object data) {
        SelectionTreeUtil.checkType(elem);
        ((MetaDataHolder)((Object)elem)).setElementData(key, data);
    }

    private static void checkType(TariffStructureNode element) {
        if (!(element instanceof MetaDataHolder)) {
            throw new IllegalArgumentException("Not a " + MetaDataHolder.class.getSimpleName() + " instance: " + element);
        }
    }

    public static boolean isStructureRoot(TariffStructureNode element) {
        return element.getNodeType() == 0;
    }

    public static boolean isModifier(TariffStructureNode element) {
        return element.getNodeType() == 3;
    }

    public static boolean isNode(TariffStructureNode element) {
        return element.getNodeType() == 1;
    }

    public static boolean isCondition(TariffStructureNode element) {
        return element.getNodeType() == 2;
    }

    public static TariffStructureNode getTreeRoot(TariffStructureNode elem) {
        if (elem == null) {
            throw new IllegalArgumentException("Element cannot be null.");
        }
        DAGNode e = elem;
        if (!SelectionTreeUtil.isStructureRoot(e)) {
            while (e.getParent() != null) {
                e = e.getParent();
            }
            if (!SelectionTreeUtil.isStructureRoot(e)) {
                throw new IllegalArgumentException("Failed to find the TariffStructure root, got " + e);
            }
        }
        return e;
    }

    private static boolean isStructureRoot(DAGNode e) {
        return e instanceof TariffStructure;
    }
}

