/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.selectiontree.conditions.string.IPVersion;
import ericsson.ere.datatype.DataType;
import java.math.BigInteger;

@Immutable
public abstract class SubNet {
    protected final BigInteger mySubNet;
    protected final BigInteger myNetMask;

    protected SubNet(BigInteger ipAddress, BigInteger netMask) {
        this.mySubNet = ipAddress.and(netMask);
        this.myNetMask = netMask;
    }

    public boolean containsIP(String theIPAddr, DataType dataType) {
        BigInteger ipValue = null;
        if (theIPAddr != null) {
            if (dataType == DataType.OCTETSTRING) {
                ipValue = this.parseIPFromOctetString(theIPAddr);
            } else if (dataType == DataType.STRING) {
                ipValue = this.parseIPFromString(theIPAddr);
            }
        }
        return ipValue != null && ipValue.and(this.myNetMask).equals(this.mySubNet);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myNetMask == null ? 0 : this.myNetMask.hashCode());
        result = 31 * result + (this.mySubNet == null ? 0 : this.mySubNet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubNet other = (SubNet)obj;
        if (this.myNetMask == null ? other.myNetMask != null : !this.myNetMask.equals(other.myNetMask)) {
            return false;
        }
        return !(this.mySubNet == null ? other.mySubNet != null : !this.mySubNet.equals(other.mySubNet));
    }

    protected static BigInteger generateNetMask(int netMaskLength, IPVersion ipVersion) {
        int maxNetMaskLength;
        BigInteger netMask = null;
        int n = maxNetMaskLength = ipVersion == IPVersion.IPv4 ? 32 : 128;
        if (netMaskLength >= 1 && netMaskLength <= maxNetMaskLength) {
            netMask = BigInteger.ZERO;
            for (int bit = 0; bit < netMaskLength; ++bit) {
                netMask = netMask.setBit(maxNetMaskLength - 1 - bit);
            }
        }
        return netMask;
    }

    protected abstract BigInteger parseIPFromString(String var1);

    protected abstract BigInteger parseIPFromOctetString(String var1);
}

