/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.simulation;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ValueResolver;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.xml.XMLUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArrayValueBuilder {
    private Map<Class<?>, ValueResolver> myResolvers = new HashMap();

    public ArrayValueBuilder withValueResolverForValueClass(Class<?> valueClass, ValueResolver resolver) {
        this.myResolvers.put(valueClass, resolver);
        return this;
    }

    public ArrayValueResultContainer build(Node config) throws Exception {
        if ("Array".equals(config.getNodeName())) {
            String sdim = this.getAttributeValueOrThrow(config, "dimensions");
            int dim = Integer.parseInt(sdim);
            NodeList children = config.getChildNodes();
            Element columns = XMLUtil.getNamedElement("Columns", children);
            if (columns == null) {
                throw new IllegalArgumentException("Missing element: Columns");
            }
            List<Element> cols = XMLUtil.getElementNodesNamed("Column", columns.getChildNodes());
            int ncol = cols.size();
            String[] columnNames = new String[ncol];
            Class[] columnClasses = new Class[ncol];
            int idx = 0;
            for (Element elem : cols) {
                columnNames[idx] = this.getAttributeValueOrThrow(elem, "name");
                columnClasses[idx] = EreClassLoader.getClass(this.getAttributeValueOrThrow(elem, "class"));
                ++idx;
            }
            Object[] values = null;
            if (dim == 1) {
                Element node = XMLUtil.getNamedElement("Data", children);
                List<Object> dataList = this.createDataList(node, columnClasses[1]);
                values = dataList.toArray((Object[])Array.newInstance(this.arrayClass(columnClasses[1]), dataList.size()));
            } else if (dim == 2) {
                ArrayList<List<Object>> columnList = new ArrayList<List<Object>>(ncol);
                List<Element> datanodes = XMLUtil.getElementNodesNamed("Data", children);
                idx = 0;
                for (Element node : datanodes) {
                    List<Object> dataList = this.createDataList(node, columnClasses[idx++]);
                    columnList.add(dataList);
                }
                if (ncol != columnList.size()) {
                    throw new IllegalArgumentException("Number of <Column> tags does not match the number of <Data> tags");
                }
                values = new Object[ncol];
                for (int i = 0; i < ncol; ++i) {
                    List l = (List)columnList.get(i);
                    values[i] = l.toArray((Object[])Array.newInstance(this.arrayClass(columnClasses[i]), l.size()));
                }
            } else {
                throw new IllegalArgumentException("Wrong number of dimensions in ArrayModel: " + dim);
            }
            return new ArrayValueResultContainer(values, columnNames);
        }
        return null;
    }

    public static ArrayValueResultContainer create(Node config) throws Exception {
        return new ArrayValueBuilder().build(config);
    }

    private Class<?> arrayClass(Class<?> class1) {
        Class<Object> ret = class1;
        if (class1 == Date.class || EREDate.class.isAssignableFrom(class1)) {
            ret = EREDate.class;
        }
        return ret;
    }

    private String getAttributeValueOrThrow(Node node, String attr) {
        Node n = node.getAttributes().getNamedItem(attr);
        if (n == null) {
            throw new IllegalArgumentException("Missing attribute: " + attr);
        }
        return n.getNodeValue();
    }

    private List<Object> createDataList(Node iterator, Class<?> theClass) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        Constructor<?> stringConstructor = null;
        try {
            stringConstructor = theClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        NodeList children = iterator.getChildNodes();
        int nchild = children.getLength();
        for (int i = 0; i < nchild; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            if ("value".equalsIgnoreCase(node.getNodeName())) {
                String value = XMLUtil.getFirstTextContent(node);
                list.add(this.parseDataValue(theClass, stringConstructor, value));
                continue;
            }
            if (!"null".equalsIgnoreCase(node.getNodeName())) continue;
            list.add(null);
        }
        return list;
    }

    private Object parseDataValue(Class<?> theClass, Constructor<?> stringConstructor, String value) throws Exception {
        Object result;
        ValueResolver resolver = this.myResolvers.get(theClass);
        if (resolver != null) {
            result = resolver.parseValueString(value);
        } else {
            DataType dt = DataType.fromClass(theClass);
            if (dt != null) {
                result = dt.parseValue(value);
            } else if (stringConstructor != null) {
                result = stringConstructor.newInstance(value);
            } else {
                throw new IllegalArgumentException(String.format("Cannot parse value '%s' of class %s.", value, theClass.getName()));
            }
        }
        return result;
    }

    public static class ArrayValueResultContainer {
        String[] myColumnNames;
        Object[] myValues;

        public ArrayValueResultContainer(Object[] values, String[] columnNames) {
            this.myValues = values;
            this.myColumnNames = columnNames;
        }

        public Object[] getValues() {
            return this.myValues;
        }

        public String[] getColumnNames() {
            return this.myColumnNames;
        }
    }
}

