/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.simulation;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.simulation.ArrayValueBuilder;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.Service;
import ericsson.ere.xml.XMLUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSetBuilder {
    public static void updateDataSet(DataSet dataset, Map<String, Object> data, ClassRepository repository) {
        for (String key : data.keySet()) {
            FieldDefinition fd = repository.getFieldDefinitionByName(key);
            if (fd != null && fd.usesTagNumber()) {
                dataset.setDataAsObject(fd.getTagNumber(), data.get(key));
                continue;
            }
            dataset.setDataAsObject(key, data.get(key));
        }
    }

    public static Map<String, Object> createMapFromSimFile(Node iterator, Service service) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if ("ERESimulationDataPanel".equals(iterator.getNodeName())) {
            DataSetBuilder.addToMap(iterator, data, service);
        } else if ("RatingDataPanel".equals(iterator.getNodeName())) {
            NodeList children = iterator.getChildNodes();
            int childcount = children.getLength();
            if (childcount < 3) {
                throw new IllegalArgumentException("Not enough data for RatingDataPanel, childCount = " + new Integer(childcount));
            }
            Node basicNode = null;
            Node inputNode = null;
            Node outputNode = null;
            for (int i = 0; i < childcount; ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                if (basicNode == null) {
                    basicNode = node;
                    continue;
                }
                if (inputNode == null) {
                    inputNode = node;
                    continue;
                }
                if (outputNode != null) continue;
                outputNode = node;
            }
            DataSetBuilder.addRatingDataPanel((Element)basicNode, data, service);
            DataSetBuilder.addRatingDataPanel((Element)inputNode, data, service);
            DataSetBuilder.addRatingDataPanel((Element)outputNode, data, service);
        }
        return data;
    }

    private static void addRatingDataPanel(Element parent, Map<String, Object> data, Service service) throws Exception {
        NodeList selected = parent.getElementsByTagName("Boolean");
        NodeList varList = parent.getElementsByTagName("Variable");
        int len = varList.getLength();
        for (int i = 0; i < len; ++i) {
            Element element = (Element)varList.item(i);
            boolean isSelected = XMLUtil.getFirstTextContent(selected.item(i)).equalsIgnoreCase("true");
            String label = element.getAttribute("label");
            Object value = element.getAttribute("value");
            if (!isSelected) continue;
            FieldDefinition fd = service.getClassRepository().getFieldDefinitionByName(label);
            if (fd != null && fd.hasUtil("EditComponent") && "ericsson.ere.gui.util.EnumEditor".equals(fd.getUtilClass("EditComponent"))) {
                Element n = XMLUtil.getNamedElement("EditComponent", fd.getDefinitionNode().getChildNodes());
                List<Element> l = XMLUtil.getElementNodesNamed("Enum", n.getChildNodes());
                for (Element enumRow : l) {
                    String name = enumRow.getAttribute("name");
                    if (!name.equals(value)) continue;
                    value = enumRow.getAttribute("value");
                    break;
                }
            } else if (fd != null && fd.isComplexType()) {
                ArrayValueBuilder.ArrayValueResultContainer result = ArrayValueBuilder.create(XMLUtil.getNamedElement("Array", element.getChildNodes()));
                value = result.getValues();
                data.put(label, result.getValues());
            } else if (fd != null) {
                value = fd.createValueObject((String)value);
            } else if (fd == null) {
                value = DataSetBuilder.getCommonValue(label, (String)value);
            }
            if (value == null) continue;
            data.put(label, value);
        }
    }

    static Object getCommonValue(String label, String value) {
        if ("Duration".equals(label)) {
            return Integer.valueOf(value);
        }
        if ("Max cost".equals(label) || "Expected cost".equals(label)) {
            return Double.valueOf(value);
        }
        if ("Expected duration".equals(label)) {
            return Long.valueOf(value);
        }
        if ("Start time".equals(label)) {
            return ERETimeFactory.parseTimeString(value);
        }
        if ("Comment".equals(label) || "Description".equals(label)) {
            return value;
        }
        return null;
    }

    private static void addToMap(Node iterator, Map<String, Object> data, Service service) throws Exception {
        NodeList nList = iterator.getChildNodes();
        int len = nList.getLength();
        for (int j = 0; j < len; ++j) {
            Node node = nList.item(j);
            if (!node.getNodeName().equals("Section")) continue;
            NodeList varList = ((Element)node).getElementsByTagName("Variable");
            for (int i = 0; i < varList.getLength(); ++i) {
                Element element = (Element)varList.item(i);
                String key = element.getAttribute("key");
                String label = element.getAttribute("label");
                Object value = element.getAttribute("value");
                boolean selected = Boolean.parseBoolean(element.getAttribute("selected"));
                if (key.length() == 0) {
                    key = label;
                }
                if (!selected) continue;
                FieldDefinition fd = service.getClassRepository(null).getFieldDefinitionByName(label);
                if (fd != null && fd.hasUtil("EditComponent") && "ericsson.ere.gui.util.EnumEditor".equals(fd.getUtilClass("EditComponent"))) {
                    value = fd.createValueObject((String)value);
                } else if (fd != null && fd.isComplexType()) {
                    ArrayValueBuilder.ArrayValueResultContainer result = ArrayValueBuilder.create(XMLUtil.getNamedElement("Array", element.getChildNodes()));
                    value = result.getValues();
                    data.put(label, result.getValues());
                } else if (fd != null) {
                    value = fd.createValueObject((String)value);
                } else if (fd == null) {
                    value = DataSetBuilder.getCommonValue(label, (String)value);
                }
                if (value == null) continue;
                data.put(label, value);
            }
        }
    }
}

