/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.simulation;

import com.ericsson.ere.dataset.DataSet;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import java.util.List;
import java.util.Map;

public class TreeDefinedFieldValidator {
    private ClassRepository myRepository;

    public TreeDefinedFieldValidator(ClassRepository repository) {
        this.myRepository = repository;
    }

    public boolean validate(DataSet dataset, Map<String, Object> data, List<String> info) {
        boolean resultState = true;
        for (String field : data.keySet()) {
            Object dataSetValue;
            FieldDefinition fd = this.myRepository.getFieldDefinitionByName(field);
            if (fd == null || !"INTERNAL".equals(fd.getParameterType()) || this.compare(fd, dataSetValue = (fd = this.myRepository.getFieldDefinitionByName(field)).usesTagNumber() ? Integer.valueOf(dataset.getDataAsInt(fd.getTagNumber())) : dataset.getDataAsObject(field), data.get(field), info)) continue;
            resultState = false;
        }
        return resultState;
    }

    private boolean compare(FieldDefinition fieldDef, Object dataValue, Object expectedValue, List<String> info) {
        boolean retState = true;
        if (dataValue.getClass() != expectedValue.getClass()) {
            retState = false;
        }
        if (!dataValue.equals(expectedValue)) {
            retState = false;
        }
        if (!retState) {
            info.add("Field '" + fieldDef.getFieldName() + "' differs. Expected: " + expectedValue + " Result: " + dataValue + "\n");
        }
        return retState;
    }
}

