/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class AbstractListModelBasedPanel<T, U extends Component>
extends JPanel {
    private ListModel myModel;

    protected AbstractListModelBasedPanel(ListModel model) {
        this(model, 0);
    }

    protected AbstractListModelBasedPanel(ListModel model, int vgap) {
        super(new GridLayout(1, 0, 0, vgap));
        this.myModel = model;
        this.myModel.addListDataListener(new ModelEventHandler());
        this.populateFromModel();
    }

    private void populateFromModel() {
        int len = this.myModel.getSize();
        for (int i = 0; i < len; ++i) {
            Object element = this.myModel.getElementAt(i);
            this.add((Component)this.createComponentForValue(element));
        }
        this.adjustLayoutAndRefresh();
    }

    protected void adjustLayoutAndRefresh() {
        int rows = this.getComponentCount();
        GridLayout layout = (GridLayout)this.getLayout();
        layout.setRows(rows > 0 ? rows : 1);
        this.validate();
        this.repaint();
    }

    protected abstract U createComponentForValue(T var1);

    private class ModelEventHandler
    implements ListDataListener {
        private ModelEventHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            int min = Math.min(e.getIndex0(), e.getIndex1());
            int max = Math.max(e.getIndex0(), e.getIndex1());
            boolean didUpdate = false;
            for (int i = min; i <= max; ++i) {
                Object replacement = AbstractListModelBasedPanel.this.createComponentForValue(AbstractListModelBasedPanel.this.myModel.getElementAt(i));
                Component current = AbstractListModelBasedPanel.this.getComponent(i);
                if (current == replacement) continue;
                AbstractListModelBasedPanel.this.remove(i);
                AbstractListModelBasedPanel.this.add((Component)replacement, i);
                didUpdate = true;
            }
            if (didUpdate) {
                AbstractListModelBasedPanel.this.adjustLayoutAndRefresh();
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            int min = Math.min(e.getIndex0(), e.getIndex1());
            int max = Math.max(e.getIndex0(), e.getIndex1());
            for (int i = min; i <= max; ++i) {
                Object comp = AbstractListModelBasedPanel.this.createComponentForValue(AbstractListModelBasedPanel.this.myModel.getElementAt(i));
                AbstractListModelBasedPanel.this.add((Component)comp, i);
            }
            AbstractListModelBasedPanel.this.adjustLayoutAndRefresh();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            int max;
            int min = Math.min(e.getIndex0(), e.getIndex1());
            for (int i = max = Math.max(e.getIndex0(), e.getIndex1()); i >= min; --i) {
                AbstractListModelBasedPanel.this.remove(i);
            }
            AbstractListModelBasedPanel.this.adjustLayoutAndRefresh();
        }
    }
}

