/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicTextFieldUI;

public class IconIndicableTextField
extends JTextField {
    private static final int ICON_GAP = 5;
    private Icon myIcon;
    private boolean myShowingIcon = false;

    public IconIndicableTextField() {
        this.setHorizontalAlignment(4);
        this.setUI(new IconRestrictingTextUI());
    }

    public IconIndicableTextField(Icon icon) {
        this();
        this.myIcon = icon;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isShowingIndication()) {
            int y = (this.getHeight() - this.myIcon.getIconHeight()) / 2;
            this.myIcon.paintIcon(null, g, 5, y);
        }
    }

    public void toggleIndication(boolean on) {
        if (on != this.myShowingIcon && this.myIcon != null) {
            this.myShowingIcon = on;
            this.repaint();
        }
    }

    public boolean isShowingIndication() {
        return this.myShowingIcon && this.myIcon != null;
    }

    public void setIcon(Icon icon) {
        if (this.myIcon != icon) {
            this.myIcon = icon;
            if (this.isShowingIndication()) {
                this.repaint();
            }
        }
    }

    @Deprecated
    public void setIndication(boolean indicate, Icon icon) {
        if (icon != this.myIcon || indicate != this.myShowingIcon) {
            this.myIcon = icon;
            this.myShowingIcon = indicate;
            this.repaint();
        }
    }

    @Deprecated
    public boolean getIndicationFor(Icon icon) {
        boolean result = false;
        if (icon.equals(this.myIcon)) {
            result = this.myShowingIcon;
        }
        return result;
    }

    @Deprecated
    public Icon getDisplayedIcon() {
        return this.myIcon;
    }

    private class IconRestrictingTextUI
    extends BasicTextFieldUI {
        private IconRestrictingTextUI() {
        }

        @Override
        protected Rectangle getVisibleEditorRect() {
            Rectangle r = super.getVisibleEditorRect();
            if (IconIndicableTextField.this.myShowingIcon && r != null) {
                int leftInset = 10 + IconIndicableTextField.this.myIcon.getIconWidth();
                r.x += leftInset;
                r.width -= leftInset;
            }
            return r;
        }
    }
}

