/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumn;

public class TableColumnResizer
extends MouseInputAdapter {
    public static Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    private int myMouseXOffset;
    private Cursor myOtherCursor = RESIZE_CURSOR;
    private JTable myTable;
    private int myMinWidth;
    private int myMaxWidth;
    private int myMaxResizeDiff = -1;

    public TableColumnResizer(JTable table, int min, int max) {
        this.myTable = table;
        this.myMinWidth = min;
        this.myMaxWidth = max;
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
    }

    public TableColumnResizer(JTable table, int min, int max, int maxResizeDiff) {
        this(table, min, max);
        this.myMaxResizeDiff = maxResizeDiff;
    }

    private boolean canResize(TableColumn column) {
        return column != null && this.myTable.getTableHeader().getResizingAllowed() && column.getResizable();
    }

    private TableColumn getResizingColumn(Point p) {
        return this.getResizingColumn(p, this.myTable.columnAtPoint(p));
    }

    private TableColumn getResizingColumn(Point p, int column) {
        int columnIndex;
        if (column == -1) {
            return null;
        }
        int row = this.myTable.rowAtPoint(p);
        if (row == -1) {
            return null;
        }
        Rectangle r = this.myTable.getCellRect(row, column, true);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int midPoint = r.x + r.width / 2;
        if (this.myTable.getTableHeader().getComponentOrientation().isLeftToRight()) {
            columnIndex = p.x < midPoint ? column - 1 : column;
        } else {
            int n = columnIndex = p.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return this.myTable.getTableHeader().getColumnModel().getColumn(columnIndex);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.myTable.getTableHeader().setDraggedColumn(null);
        this.myTable.getTableHeader().setResizingColumn(null);
        this.myTable.getTableHeader().setDraggedDistance(0);
        Point p = e.getPoint();
        int index = this.myTable.columnAtPoint(p);
        if (index == -1) {
            return;
        }
        TableColumn resizingColumn = this.getResizingColumn(p, index);
        if (!this.canResize(resizingColumn)) {
            return;
        }
        this.myTable.getTableHeader().setResizingColumn(resizingColumn);
        this.myMouseXOffset = this.myTable.getTableHeader().getComponentOrientation().isLeftToRight() ? p.x - resizingColumn.getWidth() : p.x + resizingColumn.getWidth();
    }

    private void swapCursor() {
        Cursor tmp = this.myTable.getCursor();
        this.myTable.setCursor(this.myOtherCursor);
        this.myOtherCursor = tmp;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.canResize(this.getResizingColumn(e.getPoint())) != (this.myTable.getCursor() == RESIZE_CURSOR)) {
            this.swapCursor();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int mouseX = e.getX();
        TableColumn resizingColumn = this.myTable.getTableHeader().getResizingColumn();
        boolean headerLeftToRight = this.myTable.getTableHeader().getComponentOrientation().isLeftToRight();
        if (resizingColumn != null) {
            Container container;
            int widthDiff;
            int oldWidth = resizingColumn.getWidth();
            int newWidth = headerLeftToRight ? mouseX - this.myMouseXOffset : this.myMouseXOffset - mouseX;
            newWidth = Math.max(newWidth, this.myMinWidth);
            newWidth = Math.min(newWidth, this.myMaxWidth);
            if (this.myMaxResizeDiff != -1 && ((widthDiff = newWidth - oldWidth) > this.myMaxResizeDiff || widthDiff < -this.myMaxResizeDiff)) {
                newWidth = widthDiff > 0 ? oldWidth + this.myMaxResizeDiff : oldWidth - this.myMaxResizeDiff;
            }
            resizingColumn.setWidth(newWidth);
            if (this.myTable.getTableHeader().getParent() == null || (container = this.myTable.getTableHeader().getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                return;
            }
            if (!container.getComponentOrientation().isLeftToRight() && !headerLeftToRight && this.myTable != null) {
                JViewport viewport = ((JScrollPane)container).getViewport();
                int viewportWidth = viewport.getWidth();
                int diff = newWidth - oldWidth;
                int newHeaderWidth = this.myTable.getWidth() + diff;
                Dimension tableSize = this.myTable.getSize();
                tableSize.width += diff;
                this.myTable.setSize(tableSize);
                if (newHeaderWidth >= viewportWidth && this.myTable.getAutoResizeMode() == 0) {
                    Point p = viewport.getViewPosition();
                    p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                    viewport.setViewPosition(p);
                    this.myMouseXOffset += diff;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.myTable.getTableHeader().setResizingColumn(null);
        this.myTable.getTableHeader().setDraggedColumn(null);
    }
}

