/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;

public class TableRowResizer
extends MouseInputAdapter {
    public static final Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(8);
    private int myMouseYOffset;
    private int myResizingRow;
    private Cursor myOtherCursor = RESIZE_CURSOR;
    private JTable myTable;
    private int myMinHeight;
    private int myMaxHeight;

    public TableRowResizer(JTable table, int min, int max) {
        this.myTable = table;
        this.myMinHeight = min;
        this.myMaxHeight = max;
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
    }

    private int getResizingRow(Point p) {
        return this.getResizingRow(p, this.myTable.rowAtPoint(p));
    }

    private int getResizingRow(Point p, int row) {
        if (row == -1) {
            return -1;
        }
        int col = this.myTable.columnAtPoint(p);
        if (col == -1) {
            return -1;
        }
        Rectangle r = this.myTable.getCellRect(row, col, true);
        r.grow(0, -3);
        if (r.contains(p)) {
            return -1;
        }
        int midPoint = r.y + r.height / 2;
        int rowIndex = p.y < midPoint ? row - 1 : row;
        return rowIndex;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        this.myResizingRow = this.getResizingRow(p);
        this.myMouseYOffset = p.y - this.myTable.getRowHeight(this.myResizingRow);
    }

    private void swapCursor() {
        Cursor tmp = this.myTable.getCursor();
        this.myTable.setCursor(this.myOtherCursor);
        this.myOtherCursor = tmp;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getResizingRow(e.getPoint()) >= 0 != (this.myTable.getCursor() == RESIZE_CURSOR)) {
            this.swapCursor();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int mouseY = e.getY();
        if (this.myResizingRow >= 0) {
            int newHeight = mouseY - this.myMouseYOffset;
            newHeight = Math.max(newHeight, this.myMinHeight);
            if ((newHeight = Math.min(newHeight, this.myMaxHeight)) > 0) {
                this.myTable.setRowHeight(this.myResizingRow, newHeight);
            }
        }
    }
}

