/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TransposingTableModel
implements TableModel {
    private TableModel myInnerModel;

    public TransposingTableModel(TableModel inner) {
        this.myInnerModel = inner;
    }

    public TableModel getInnerModel() {
        return this.myInnerModel;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.myInnerModel.addTableModelListener(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return this.myInnerModel.getRowCount() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return Integer.toString(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.myInnerModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.myInnerModel.getColumnName(rowIndex);
        }
        return this.myInnerModel.getValueAt(columnIndex - 1, rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return this.myInnerModel.isCellEditable(columnIndex - 1, rowIndex);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.myInnerModel.removeTableModelListener(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.myInnerModel.setValueAt(aValue, columnIndex - 1, rowIndex);
    }

    public static class HeaderColumnRenderer
    extends JLabel
    implements TableCellRenderer {
        public HeaderColumnRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

