/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Arrays;

public class WeightedSingleLineLayoutManager
implements LayoutManager {
    private int myGap;
    private int[] myWeights;
    private Orientation myOrientation;

    public WeightedSingleLineLayoutManager(int[] weights) {
        this(weights, Orientation.Horizontal, 0);
    }

    public WeightedSingleLineLayoutManager(int[] weights, Orientation orientation) {
        this(weights, orientation, 0);
    }

    public WeightedSingleLineLayoutManager(int[] weights, Orientation orientation, int gap) {
        this.checkWeights(weights);
        this.myGap = gap;
        this.myWeights = Arrays.copyOf(weights, weights.length);
        this.myOrientation = orientation;
    }

    private void checkWeights(int[] weights) {
        if (weights == null || weights.length == 0) {
            throw new IllegalArgumentException("Must specify at least one weight.");
        }
        for (int i = 0; i < weights.length; ++i) {
            if (weights[i] >= 0) continue;
            throw new IllegalArgumentException("Negative weight found at index " + i);
        }
        if (this.sumOf(weights) != 100) {
            throw new IllegalArgumentException("The weights must sum to 100.");
        }
    }

    private int sumOf(int[] ints) {
        int sum = 0;
        for (int i = 0; i < ints.length; ++i) {
            sum += ints[i];
        }
        return sum;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        if (target.getComponentCount() != this.myWeights.length) {
            return;
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            Dimension tsize = target.getSize();
            int maxwidth = tsize.width - (insets.left + insets.right);
            int maxheight = tsize.height - (insets.top + insets.bottom);
            boolean rtl = !target.getComponentOrientation().isLeftToRight();
            int x = insets.left;
            int y = insets.top;
            int sign = 1;
            if (rtl) {
                x += maxwidth;
                y += maxheight;
                sign = -1;
            }
            Component[] components = target.getComponents();
            int gapsize = this.myGap * (components.length - 1);
            int[] sizes = this.calcSizes(components, maxwidth - gapsize, maxheight - gapsize);
            for (int i = 0; i < components.length; ++i) {
                Component c = target.getComponent(i);
                int csize = sizes[i];
                if (this.myOrientation == Orientation.Horizontal) {
                    int cx = rtl ? x - csize : x;
                    this.setBounds(c, cx, y, csize, maxheight);
                    x += sign * (csize + this.myGap);
                    continue;
                }
                int cy = rtl ? y - csize : y;
                this.setBounds(c, x, cy, maxwidth, csize);
                y += sign * (csize + this.myGap);
            }
        }
    }

    private void setBounds(Component c, int x, int y, int w, int h) {
        Rectangle r = c.getBounds();
        if (r.x != x || r.y != y || r.width != w || r.height != h) {
            c.setBounds(x, y, w, h);
        }
    }

    private int[] calcSizes(Component[] components, int maxwidth, int maxheight) {
        assert (components.length == this.myWeights.length);
        int max = this.myOrientation == Orientation.Horizontal ? maxwidth : maxheight;
        int nmembers = components.length;
        int[] sizes = new int[nmembers];
        for (int i = 0; i < nmembers; ++i) {
            if (this.myWeights[i] != 0) continue;
            Dimension d = components[i].getPreferredSize();
            sizes[i] = this.myOrientation == Orientation.Horizontal ? d.width : d.height;
        }
        int reducedMax = max - this.sumOf(sizes);
        for (int i = 0; i < nmembers; ++i) {
            if (this.myWeights[i] <= 0) continue;
            float fw = (float)(reducedMax * this.myWeights[i]) / 100.0f;
            sizes[i] = Math.round(fw);
        }
        int n = sizes.length - 1;
        sizes[n] = sizes[n] + (max - this.sumOf(sizes));
        return sizes;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.layoutSize(target, false);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.layoutSize(target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container target, boolean pref) {
        if (target.getComponentCount() != this.myWeights.length) {
            return new Dimension(0, 0);
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Dimension d;
                Component m = target.getComponent(i);
                Dimension dimension = d = pref ? m.getPreferredSize() : m.getMinimumSize();
                if (this.myOrientation == Orientation.Horizontal) {
                    dim.height = Math.max(dim.height, d.height);
                    dim.width += d.width;
                    continue;
                }
                dim.width = Math.max(dim.width, d.width);
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.height += insets.top + insets.bottom;
            dim.width += insets.left + insets.right;
            if (this.myOrientation == Orientation.Horizontal) {
                dim.width += this.myGap * (nmembers - 1);
            } else {
                dim.height += this.myGap * (nmembers - 1);
            }
            return dim;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public static enum Orientation {
        Horizontal,
        Vertical;

    }
}

