/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing.table;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class FilterableTableModel<T>
extends AbstractTableModel {
    protected List<T> myEntries = new LinkedList<T>();
    protected List<T> myVisibleEntries = new LinkedList<T>();

    protected abstract boolean shouldEntryBeVisible(T var1, int var2);

    @Override
    public abstract Object getValueAt(int var1, int var2);

    public abstract void refresh();

    protected void protAdd(T obj) {
        this.myEntries.add(obj);
        if (this.shouldEntryBeVisible(obj, this.myEntries.size() - 1)) {
            this.myVisibleEntries.add(obj);
            int row = this.myVisibleEntries.size() - 1;
            this.fireTableRowsInserted(row, row);
        }
    }

    @Override
    public int getRowCount() {
        return this.myVisibleEntries.size();
    }

    public T getEntryAt(int row) {
        T result = null;
        try {
            result = this.myVisibleEntries.get(row);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    protected void updateVisibleEntries() {
        boolean needListChange = false;
        ArrayList<T> temp = new ArrayList<T>();
        for (int i = 0; i < this.myEntries.size(); ++i) {
            T entry = this.myEntries.get(i);
            if (this.shouldEntryBeVisible(entry, i)) {
                temp.add(entry);
                needListChange |= !this.myVisibleEntries.contains(entry);
                continue;
            }
            needListChange |= this.myVisibleEntries.contains(entry);
        }
        if (needListChange |= this.myVisibleEntries.size() != temp.size()) {
            this.myVisibleEntries.clear();
            this.myVisibleEntries.addAll(temp);
            this.fireTableChanged(new FilterTableModelEvent(this));
        }
    }

    public void clearAllEntries() {
        int max = this.myVisibleEntries.size();
        this.myVisibleEntries.clear();
        this.myEntries.clear();
        this.fireTableRowsDeleted(0, max != 0 ? max - 1 : 0);
    }

    public void clearEntry(T anyEntry) {
        int index = this.myVisibleEntries.indexOf(anyEntry);
        this.myEntries.remove(anyEntry);
        this.myVisibleEntries.remove(anyEntry);
        if (index >= 0) {
            this.fireTableRowsDeleted(index, index);
        }
    }

    public static class FilterTableModelEvent
    extends TableModelEvent {
        public FilterTableModelEvent(TableModel source) {
            super(source);
        }
    }
}

