/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.SelectionTreeQualifier;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import com.ericsson.ere.trace.TraceHelper;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.Traceable;
import com.ericsson.ere.trace.filter.HtmlTraceFilter;
import com.ericsson.ere.trace.filter.PlainTextTraceFilter;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.StringUtil;
import java.util.List;

public final class TraceInfoHelper {
    private static final Object SUPPRESS_TRACE_GENERATION = new Object();
    public static final Object LEVEL = new Object();
    public static final Object INDEX = new Object();

    private TraceInfoHelper() {
    }

    public static final Object getTracedElement(TracePoint point) {
        Object tracedElement = null;
        TreeElementTraceWrapper wrapper = (TreeElementTraceWrapper)point.getInfo(TraceHelper.TRACED_ELEMENT);
        if (wrapper != null) {
            tracedElement = wrapper.getWrappedElement();
        }
        return tracedElement;
    }

    public static final Throwable getThrowable(TracePoint point) {
        return TraceHelper.getThrowable(point);
    }

    public static boolean traceGenerationIsSuppressed(TracePoint tp) {
        return tp.getInfo(SUPPRESS_TRACE_GENERATION) != null;
    }

    public static void suppressTraceGeneration(TracePoint tp) {
        tp.addInfo(SUPPRESS_TRACE_GENERATION, Boolean.TRUE);
    }

    public static String getExceptionTrace(Throwable exception, String prefix, String suffix, String sep) {
        return TraceInfoHelper.getExceptionTrace(exception, prefix, suffix, sep, new DefaultExceptionMessageFormatter());
    }

    public static String getExceptionTrace(Throwable exception, String prefix, String suffix, String sep, ExceptionMessageFormatter formatter) {
        if (exception == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(prefix);
        if (!TraceInfoHelper.skipExceptionTrace(exception)) {
            buf.append(formatter.formatExceptionMessage(exception.toString()));
        }
        for (Throwable e = exception.getCause(); e != null; e = e.getCause()) {
            if (TraceInfoHelper.skipExceptionTrace(e)) continue;
            buf.append(sep);
            buf.append(formatter.formatExceptionMessage(e.toString()));
        }
        buf.append(suffix);
        return buf.toString();
    }

    private static boolean skipExceptionTrace(Throwable e) {
        return e instanceof TreeExecutionException && e.getCause() != null && e.getMessage().startsWith(e.getCause().getClass().getName() + ":");
    }

    public static String getAllTraceInfo(TraceNodeInterface tni, TracePointProvider provider) {
        StringBuilder buf = new StringBuilder();
        final HtmlTraceFilter filter = new HtmlTraceFilter();
        buf.append("<html><body>");
        buf.append(TraceInfoHelper.getExceptionTrace(tni.getException(), "", "<br>", "<br>", new ExceptionMessageFormatter(){

            @Override
            public String formatExceptionMessage(String s) {
                return filter.filterTrace("$$" + s + "$$");
            }
        }));
        buf.append("<table width=\"100%\" border=\"0\" cellpadding=\"4\">");
        int noOfTracePoints = tni.getNumberOfTracePoints();
        if (noOfTracePoints > 0) {
            for (int i = 0; i < noOfTracePoints; ++i) {
                String theTraceDiff;
                TracePoint tp = provider.getTracePoint(i);
                String theTraceDescription = tni.describeTracePoint(i);
                if (i % 2 == 0) {
                    buf.append("<tr>");
                } else {
                    buf.append("<tr bgcolor=\"#CAD7F4\">");
                }
                if (noOfTracePoints > 1) {
                    buf.append("<td valign=\"top\"><b>");
                    buf.append(i);
                    buf.append("</b></td>");
                }
                buf.append("<td nowrap>");
                if (theTraceDescription != null) {
                    buf.append(filter.filterTrace(theTraceDescription));
                }
                if ((theTraceDiff = tp.getTraceDataSetDiff()) != null && theTraceDiff.length() > 0) {
                    buf.append("<br><br>");
                    buf.append(filter.filterTrace(theTraceDiff));
                }
                buf.append("</td></tr>");
            }
        }
        buf.append("</table>");
        buf.append("</body></html>");
        return buf.toString();
    }

    static String getTariffStructureTraceDescription(TariffStructure structure, TracePoint tp) {
        return TraceInfoHelper.getTraceDescription(structure, "the tariff structure node", tp);
    }

    static String getStatementTraceDescription(ExecutableNode statement, TracePoint tp) {
        return TraceInfoHelper.getTraceDescription(statement, "statement " + statement.getName(), tp);
    }

    static String getConditionTraceDescription(Conditionality condition, TracePoint tp) {
        return TraceInfoHelper.getTraceDescription(condition, ((TariffStructureNode)((Object)condition)).getNodeId(), tp);
    }

    static String getModifierTraceDescription(Performable modifier, TracePoint tp) {
        StringBuilder descriptionBuilder = new StringBuilder(TraceInfoHelper.getTraceDescription(modifier, modifier.getTypename(), tp));
        TraceInfoHelper.addSTQInfoToTrace(tp, descriptionBuilder);
        return descriptionBuilder.toString();
    }

    public static String getTraceDescription(Traceable t, String id, TracePoint tp) {
        String trace = tp.getTraceString();
        if (trace != null) {
            return trace;
        }
        try {
            trace = t.describeTrace(tp);
        }
        catch (Exception e) {
            trace = "A " + e.toString() + " was thrown when printing trace for " + id + ".";
        }
        return trace;
    }

    static String createTariffStructureTraceString(TariffStructure structure, TracePoint tp, int level) {
        StringBuilder trace = new StringBuilder();
        StringUtil.repeat(" ", level, trace);
        String otherRowPrefix = "\n" + trace.toString() + " ";
        trace.append(TraceInfoHelper.getTariffStructureTraceDescription(structure, tp));
        TraceInfoHelper.appendExecutionExceptionTrace(tp, trace);
        TraceInfoHelper.appendTraceExceptionTrace(tp, trace);
        return trace.toString().replace("\n", otherRowPrefix);
    }

    static String createNodeStatementTraceString(ExecutableNode statement, TracePoint tp, int level) {
        StringBuilder trace = new StringBuilder();
        StringUtil.repeat(" ", level, trace);
        String otherRowPrefix = "\n" + trace.toString() + " ";
        String nodeInfo = TraceInfoHelper.getStatementTraceDescription(statement, tp);
        if (nodeInfo == null) {
            trace.append("========================================== [");
            trace.append(statement.getName());
            trace.append("]");
        } else {
            trace.append(nodeInfo);
            TraceInfoHelper.appendExecutionExceptionTrace(tp, trace);
            TraceInfoHelper.appendTraceExceptionTrace(tp, trace);
        }
        return trace.toString().replace("\n", otherRowPrefix);
    }

    static String createConditionTraceString(Conditionality condition, TracePoint tp, int level, int index) {
        StringBuilder prefix = new StringBuilder();
        StringUtil.repeat(" ", level, prefix);
        String firstRowPrefix = prefix.append(index).append("?").toString();
        String otherRowPrefix = "\n" + firstRowPrefix + " ";
        String test = (Boolean)tp.getInfo(TraceNodeInterface.TEST_RESULT) != false ? "<TRUE> " : "<FALSE> ";
        String trace = TraceInfoHelper.createConditionTraceString(condition, tp);
        PlainTextTraceFilter filter = new PlainTextTraceFilter();
        StringBuilder traceBuilder = new StringBuilder(firstRowPrefix);
        traceBuilder.append(" ").append(test).append(filter.filterTrace(trace).trim());
        return traceBuilder.toString().replace("\n", otherRowPrefix);
    }

    static String createConditionTraceString(Conditionality condition, TracePoint tp) {
        String trace = TraceInfoHelper.getConditionTraceDescription(condition, tp);
        if (trace == null) {
            trace = "";
        }
        StringBuilder sb = new StringBuilder(trace);
        TraceInfoHelper.appendExecutionExceptionTrace(tp, sb);
        TraceInfoHelper.appendTraceExceptionTrace(tp, sb);
        return sb.toString();
    }

    private static void appendExecutionExceptionTrace(TracePoint tp, StringBuilder sb) {
        Throwable throwable = TraceInfoHelper.getThrowable(tp);
        if (TraceHelper.tracePointIsOriginForThrowable(tp, throwable)) {
            sb.append(TraceInfoHelper.getExceptionTrace(throwable, "\nExecution ERROR:\n ", "", "\n "));
        }
    }

    private static void appendTraceExceptionTrace(TracePoint tp, StringBuilder sb) {
        sb.append(TraceInfoHelper.getExceptionTrace((Throwable)tp.getInfo(TraceHelper.TRACE_EXCEPTION_INFO), "\nTrace ERROR:\n ", "", "\n "));
    }

    static String createModifierTraceString(Performable modifier, TracePoint tp, int level, int index) {
        StringBuilder prefix = new StringBuilder();
        StringUtil.repeat(" ", level, prefix);
        String firstRowPrefix = prefix.append(index).append("!").toString();
        String otherRowPrefix = "\n" + firstRowPrefix + " ";
        String modifierTraceString = TraceInfoHelper.createModifierTraceString(modifier, tp);
        PlainTextTraceFilter filter = new PlainTextTraceFilter();
        StringBuilder traceBuilder = new StringBuilder(firstRowPrefix);
        traceBuilder.append(" ").append(filter.filterTrace(modifierTraceString).trim());
        return traceBuilder.toString().replace("\n", otherRowPrefix);
    }

    static String createModifierTraceString(Performable modifier, TracePoint tp) {
        String trace = TraceInfoHelper.getModifierTraceDescription(modifier, tp);
        if (trace == null) {
            trace = "";
        }
        StringBuilder sb = new StringBuilder(trace);
        TraceInfoHelper.appendExecutionExceptionTrace(tp, sb);
        TraceInfoHelper.appendTraceExceptionTrace(tp, sb);
        return sb.toString();
    }

    public static String createTraceStringForTracePoint(TracePoint tp) {
        TreeElementTraceWrapper treeElementWrapper = (TreeElementTraceWrapper)tp.getInfo(TraceHelper.TRACED_ELEMENT);
        int level = (Integer)tp.getInfo(LEVEL);
        int index = (Integer)tp.getInfo(INDEX);
        return treeElementWrapper.getTraceString(tp, level, index);
    }

    public static String createDenseTraceStringForTracePoint(TracePoint tp) {
        TreeElementTraceWrapper treeElementWrapper = (TreeElementTraceWrapper)tp.getInfo(TraceHelper.TRACED_ELEMENT);
        return treeElementWrapper.getTraceString(tp);
    }

    static void addSTQInfoToTrace(TracePoint tp, StringBuilder traceStringBuilder) {
        List stqList = (List)tp.getInfo(TraceHelper.STQ_LIST);
        if (stqList != null && stqList.size() > 0) {
            traceStringBuilder.append("\nQualifier hit list: ");
            for (SelectionTreeQualifier qualifier : stqList) {
                traceStringBuilder.append(qualifier).append(", ");
            }
            traceStringBuilder.delete(traceStringBuilder.length() - 2, traceStringBuilder.length());
        }
    }

    static void addTariffStructureToTracePoint(TariffStructure structure, TracePoint tp) {
        tp.addInfo(TraceHelper.TRACED_ELEMENT, new TariffStructureTraceWrapper(structure));
    }

    static void addExecutableNodeToTracePoint(ExecutableNode node, TracePoint tp) {
        tp.addInfo(TraceHelper.TRACED_ELEMENT, new ExecutableNodeTraceWrapper(node));
    }

    static void addConditionalityToTracePoint(Conditionality condition, TracePoint tp) {
        tp.addInfo(TraceHelper.TRACED_ELEMENT, new ConditionTraceWrapper(condition));
    }

    static void addPerformableToTracePoint(Performable performable, TracePoint tp) {
        tp.addInfo(TraceHelper.TRACED_ELEMENT, new PerformableTraceWrapper(performable));
    }

    static class PerformableTraceWrapper
    implements TreeElementTraceWrapper {
        private final Performable myModifier;

        PerformableTraceWrapper(Performable modifier) {
            this.myModifier = modifier;
        }

        @Override
        public String getTraceString(TracePoint tp, int level, int index) {
            return TraceInfoHelper.createModifierTraceString(this.myModifier, tp, level, index);
        }

        @Override
        public String getTraceString(TracePoint tp) {
            return TraceInfoHelper.createModifierTraceString(this.myModifier, tp);
        }

        @Override
        public Object getWrappedElement() {
            return this.myModifier;
        }
    }

    static class ConditionTraceWrapper
    implements TreeElementTraceWrapper {
        private final Conditionality myCondition;

        ConditionTraceWrapper(Conditionality condition) {
            this.myCondition = condition;
        }

        @Override
        public String getTraceString(TracePoint tp, int level, int index) {
            return TraceInfoHelper.createConditionTraceString(this.myCondition, tp, level, index);
        }

        @Override
        public String getTraceString(TracePoint tp) {
            return TraceInfoHelper.createConditionTraceString(this.myCondition, tp);
        }

        @Override
        public Object getWrappedElement() {
            return this.myCondition;
        }
    }

    static class ExecutableNodeTraceWrapper
    implements TreeElementTraceWrapper {
        private final ExecutableNode myStatement;

        ExecutableNodeTraceWrapper(ExecutableNode statement) {
            this.myStatement = statement;
        }

        @Override
        public String getTraceString(TracePoint tp, int level, int index) {
            return TraceInfoHelper.createNodeStatementTraceString(this.myStatement, tp, level);
        }

        @Override
        public String getTraceString(TracePoint tp) {
            return TraceInfoHelper.getStatementTraceDescription(this.myStatement, tp);
        }

        @Override
        public Object getWrappedElement() {
            return this.myStatement;
        }
    }

    static class TariffStructureTraceWrapper
    implements TreeElementTraceWrapper {
        private final TariffStructure myStructure;

        TariffStructureTraceWrapper(TariffStructure structure) {
            this.myStructure = structure;
        }

        @Override
        public String getTraceString(TracePoint tp, int level, int index) {
            return TraceInfoHelper.createTariffStructureTraceString(this.myStructure, tp, level);
        }

        @Override
        public String getTraceString(TracePoint tp) {
            return TraceInfoHelper.getTariffStructureTraceDescription(this.myStructure, tp);
        }

        @Override
        public Object getWrappedElement() {
            return this.myStructure;
        }
    }

    static interface TreeElementTraceWrapper {
        public String getTraceString(TracePoint var1, int var2, int var3);

        public String getTraceString(TracePoint var1);

        public Object getWrappedElement();
    }

    private static class DefaultExceptionMessageFormatter
    implements ExceptionMessageFormatter {
        private DefaultExceptionMessageFormatter() {
        }

        @Override
        public String formatExceptionMessage(String s) {
            return s;
        }
    }

    public static interface ExceptionMessageFormatter {
        public String formatExceptionMessage(String var1);
    }

    public static interface TracePointProvider {
        public TracePoint getTracePoint(int var1);
    }
}

