/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.interfaces.MutableTariffStructure;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import com.ericsson.ere.selectiontree.statements.Statement;
import com.ericsson.ere.selectiontree.structures.AbstractTariffStructure;
import com.ericsson.ere.trace.TraceHelper;
import com.ericsson.ere.trace.TraceInfoHelper;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeInterfaceV2;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.filter.HtmlTraceFilter;
import ericsson.ere.interfaces.XMLInitializable;
import java.util.ArrayList;
import java.util.List;

public class TraceNodeTariffStructure
extends AbstractTariffStructure
implements TraceNodeInterfaceV2 {
    private TraceNodeInterface myTraceNodeParent;
    private TariffStructure myTariffStructure;
    private TracePoint myTracePoint;
    private ArrayList<TraceNodeInterface> myChildNodes;
    private boolean isExecuted = false;
    private Throwable myException = null;
    private boolean hasCheckedForModifer = false;
    private boolean hasModifierBeenExecuted = false;
    private int myLevel = 0;
    private int mySequenceNo = 0;

    @Override
    public void addChild(TraceNodeInterface child) {
        if (this.myChildNodes == null) {
            this.myChildNodes = new ArrayList();
        }
        this.myChildNodes.add(child);
    }

    @Override
    public List<TraceNodeInterface> getChildren() {
        return this.myChildNodes;
    }

    @Override
    public void add(XMLInitializable child) {
        ((MutableTariffStructure)((Object)this.myTariffStructure)).add((Statement)child);
        this.addChild((TraceNodeInterface)child);
    }

    @Override
    public void setExecuted() {
        this.isExecuted = true;
    }

    @Override
    public boolean getExecuted() {
        return this.isExecuted;
    }

    @Override
    public Throwable getException() {
        return this.myException;
    }

    public TraceNodeTariffStructure(TariffStructure ts) {
        this.myTariffStructure = ts;
    }

    @Override
    public void execute(DataSet dataSet) {
        TraceHelper.executeTraceTreeElement(this, dataSet);
    }

    @Override
    public String getAllTraceInfo() {
        HtmlTraceFilter filter = new HtmlTraceFilter();
        return filter.filterTrace(this.getTariffStructureTraceDescription(this.myTracePoint));
    }

    @Override
    public String getTraceInfo(int seqNo) {
        String traceString = null;
        if (!TraceInfoHelper.traceGenerationIsSuppressed(this.myTracePoint)) {
            traceString = TraceInfoHelper.createTariffStructureTraceString(this.myTariffStructure, this.myTracePoint, this.myLevel);
        }
        return traceString;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        return null;
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public String toString() {
        return this.myTariffStructure.toString();
    }

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    public void setParent(TraceNodeInterface parent) {
        this.myTraceNodeParent = parent;
        this.myLevel = parent.getLevel() + 1;
        this.rebuildLevels();
    }

    @Override
    public void setChildIndex(int index) {
    }

    @Override
    public boolean hasRunModifier() {
        if (!this.hasCheckedForModifer) {
            this.hasCheckedForModifer = true;
            for (int i = 0; this.myChildNodes != null && i < this.myChildNodes.size(); ++i) {
                if (!this.myChildNodes.get(i).hasRunModifier()) continue;
                this.hasModifierBeenExecuted = true;
                return true;
            }
        }
        return this.hasModifierBeenExecuted;
    }

    @Override
    public int getNextSeqNo() {
        return this.mySequenceNo++;
    }

    @Override
    public void rebuildLevels() {
        if (this.myTraceNodeParent != null) {
            this.myLevel = this.myTraceNodeParent.getLevel() + 1;
            if (this.myChildNodes != null) {
                for (int i = 0; i < this.myChildNodes.size(); ++i) {
                    this.myChildNodes.get(i).rebuildLevels();
                }
            }
        }
    }

    @Override
    public int getNumberOfTracePoints() {
        return 1;
    }

    @Override
    public String describeTracePoint(int index) {
        return this.getTariffStructureTraceDescription(this.myTracePoint);
    }

    private String getTariffStructureTraceDescription(TracePoint tp) {
        return TraceInfoHelper.getTraceDescription(this.myTariffStructure, "the tariff structure node", tp);
    }

    @Override
    public String getNodeLabel() {
        return this.myTariffStructure.toString();
    }

    @Override
    public TracePoint traceTreeElement(DataSet dataSet) {
        return TraceHelper.traceTariffStructure(this.myTariffStructure, dataSet);
    }

    @Override
    public void addTracePoint(TracePoint tp) {
        this.myTracePoint = tp;
    }

    @Override
    public void setException(Throwable t) {
        this.myException = t;
    }
}

