/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeTariffStructure;
import com.ericsson.ere.trace.TraceOrderHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class TraceTreeInfo {
    public static final int DETAILED_TRACE = 0;
    protected TraceNodeTariffStructure myTraceNodeTariffStructure;
    protected TraceOrderHandler myTraceOrderHandler;
    protected DataSet myPreDataSet;
    protected DataSet myPostDataSet;

    public TraceTreeInfo(TraceNodeTariffStructure structure, DataSet pre, DataSet post) {
        this.myTraceNodeTariffStructure = structure;
        this.myPreDataSet = pre;
        this.myPostDataSet = post;
        this.myTraceOrderHandler = post.getTraceOrderHandler();
    }

    public void setStructure(TraceNodeTariffStructure structure) {
        this.myTraceNodeTariffStructure = structure;
    }

    public TraceNodeTariffStructure getStructure() {
        return this.myTraceNodeTariffStructure;
    }

    public DataSet getPostDataSet() {
        return this.myPostDataSet;
    }

    public DataSet getPreDataSet() {
        return this.myPreDataSet;
    }

    public void setHandler(TraceOrderHandler handler) {
        this.myTraceOrderHandler = handler;
    }

    public TraceOrderHandler getHandler() {
        return this.myTraceOrderHandler;
    }

    public List<TraceOrderHandler.ExecutedTraceNode> getTraceList() {
        return this.myTraceOrderHandler.getOrderList();
    }

    public String getTraceAsString(int details) {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        this.getPreDataSet().printTraceHead(writer);
        writer.println();
        List<TraceOrderHandler.ExecutedTraceNode> list = this.getTraceList();
        for (int x = 0; x < list.size(); ++x) {
            int seqNo;
            TraceOrderHandler.ExecutedTraceNode n = list.get(x);
            TraceNodeInterface tni = n.getExecutedNode();
            String traceInfo = tni.getTraceInfo(seqNo = n.getSeqNo());
            if (traceInfo == null) continue;
            writer.println(traceInfo);
        }
        writer.println();
        this.getPostDataSet().printTraceTail(writer, this.getPreDataSet());
        writer.flush();
        return buf.toString();
    }
}

