/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace.filter;

import com.ericsson.ere.trace.filter.AbstractTraceFilter;
import java.io.PrintWriter;

public class HtmlTraceFilter
extends AbstractTraceFilter {
    private int myRowCount = 0;
    private int myColCount = 0;

    @Override
    protected void print(String parString, PrintWriter parWriter) {
        if (parString.startsWith(" ")) {
            parWriter.print(parString.replace(" ", "&nbsp;"));
        } else {
            parWriter.print(parString);
        }
    }

    @Override
    protected void beginBold(PrintWriter parWriter) {
        parWriter.print("<b>");
    }

    @Override
    protected void endBold(PrintWriter parWriter) {
        parWriter.print("</b>");
    }

    @Override
    protected void beginItalic(PrintWriter parWriter) {
        parWriter.print("<i>");
    }

    @Override
    protected void endItalic(PrintWriter parWriter) {
        parWriter.print("</i>");
    }

    @Override
    protected void beginMonospace(PrintWriter parWriter) {
        parWriter.print("<code>");
    }

    @Override
    protected void endMonospace(PrintWriter parWriter) {
        parWriter.print("</code>");
    }

    @Override
    protected void newline(PrintWriter parWriter) {
        parWriter.println("<br>");
    }

    @Override
    protected void beginTable(PrintWriter parWriter) {
        parWriter.println("<table cellpadding=\"8\" cellspacing=\"0\" border=\"0\">");
        this.myRowCount = 0;
    }

    @Override
    protected void beginTableHeader(PrintWriter parWriter) {
        parWriter.print("<th nowrap><code><font color=\"#FFFFFF\">");
    }

    @Override
    protected void endTableHeader(PrintWriter parWriter) {
        parWriter.print("</font></code></th>");
    }

    @Override
    protected void beginTableRow(PrintWriter parWriter) {
        this.myColCount = 0;
        if (this.myRowCount == 0) {
            parWriter.print("<tr align=\"right\" bgcolor=\"#000000\">");
        } else if (this.myRowCount % 2 != 0) {
            parWriter.print("<tr align=\"right\">");
        } else {
            parWriter.print("<tr align=\"right\">");
        }
    }

    @Override
    protected void beginTableCell(PrintWriter parWriter) {
        if (this.myColCount % 2 != 0) {
            parWriter.print("<td nowrap bgcolor=\"#EFEFEF\"><code>");
        } else {
            parWriter.print("<td nowrap bgcolor=\"#F4F4F4\"><code>");
        }
    }

    @Override
    protected void endTableCell(PrintWriter parWriter) {
        parWriter.print("</code></td>");
        ++this.myColCount;
    }

    @Override
    protected void endTableRow(PrintWriter parWriter) {
        parWriter.println("</tr>");
        ++this.myRowCount;
    }

    @Override
    protected void endTable(PrintWriter parWriter) {
        parWriter.println("</table>");
        parWriter.println("<br>");
    }

    @Override
    protected void beginTrace(PrintWriter parWriter) {
        parWriter.println("<html>");
    }

    @Override
    protected void endTrace(PrintWriter parWriter) {
        parWriter.println("</html>");
    }

    @Override
    protected void beginHeader(int parLevel, PrintWriter parWriter) {
        switch (parLevel) {
            case 1: {
                parWriter.print("<h3>");
                break;
            }
            case 2: {
                parWriter.print("<h2>");
                break;
            }
            case 3: {
                parWriter.print("<h1>");
                break;
            }
            default: {
                parWriter.print("<h4>");
            }
        }
    }

    @Override
    protected void endHeader(int parLevel, PrintWriter parWriter) {
        switch (parLevel) {
            case 1: {
                parWriter.print("</h3>");
                break;
            }
            case 2: {
                parWriter.print("</h2>");
                break;
            }
            case 3: {
                parWriter.print("</h1>");
                break;
            }
            default: {
                parWriter.print("</h4>");
            }
        }
    }

    @Override
    protected void beginHighlight(PrintWriter parWriter) {
        parWriter.print("<font color=\"red\"><b>");
    }

    @Override
    protected void endHighlight(PrintWriter parWriter) {
        parWriter.print("</b></font>");
    }

    @Override
    protected void horizontalRuler(PrintWriter parWriter) {
        parWriter.print("<hr>");
    }

    @Override
    protected void space(PrintWriter parWriter) {
        parWriter.print("&nbsp;");
    }
}

