/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.CloneStrategyException;
import com.ericsson.ere.util.ObjectCloner;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public abstract class AbstractStrategyBasedObjectCloner
implements ObjectCloner {
    @Override
    public <T> T cloneObject(T object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        List<CloneStrategy> strategies = this.strategies();
        T clone = null;
        if (strategies != null) {
            for (CloneStrategy strategy : strategies) {
                try {
                    clone = strategy.attemptClone(this, object);
                }
                catch (SecurityException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof CloneNotSupportedException) {
                        throw (CloneNotSupportedException)cause;
                    }
                    Throwable reason = cause != null ? cause : e;
                    throw new CloneNotSupportedException("Strategy \"" + strategy.getClass().getSimpleName() + "\" failed because: " + reason);
                }
                catch (CloneStrategyException e) {
                    throw new CloneNotSupportedException("Strategy \"" + strategy.getClass().getSimpleName() + "\" failed because: " + e.getCause());
                }
                if (clone == null) continue;
                break;
            }
        }
        if (clone == null) {
            throw new CloneNotSupportedException("Don't know how to clone an object of type " + object.getClass());
        }
        return clone;
    }

    protected abstract List<CloneStrategy> strategies();

    static interface CloneStrategy {
        public <T> T attemptClone(ObjectCloner var1, T var2) throws SecurityException, CloneNotSupportedException, InvocationTargetException, CloneStrategyException;
    }
}

