/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.util.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;

public final class CloneUtil {
    private CloneUtil() {
    }

    public static Collection<Object> newCollection(Object template, int size) {
        AbstractCollection c = null;
        if (template instanceof List) {
            if (template instanceof ArrayList) {
                c = new ArrayList(size);
            } else if (template instanceof LinkedList) {
                c = new LinkedList();
            } else if (template instanceof Stack) {
                c = new Stack();
            } else if (template instanceof Vector) {
                c = new Vector(size);
            }
        } else if (template instanceof Set) {
            if (template instanceof LinkedHashSet) {
                c = new LinkedHashSet();
            } else if (template instanceof HashSet) {
                c = new HashSet();
            } else if (template instanceof TreeSet) {
                c = new TreeSet();
            }
        }
        if (c == null) {
            c = new ArrayList(size);
        }
        return c;
    }

    public static boolean isKnownImmutable(Object o) {
        if (o == null) {
            return true;
        }
        Class<?> cls = o.getClass();
        if (cls == String.class) {
            return true;
        }
        if (cls == Boolean.class) {
            return true;
        }
        if (cls == Integer.class || cls == Short.class || cls == Long.class || cls == Byte.class) {
            return true;
        }
        if (cls == Double.class || cls == Float.class) {
            return true;
        }
        if (cls == BigInteger.class || cls == BigDecimal.class) {
            return true;
        }
        if (cls == RatingDecimal.class) {
            return true;
        }
        if (cls.isEnum()) {
            return true;
        }
        return cls.isAnnotationPresent(Immutable.class);
    }

    public static <T> T deepCopy(T object) throws IOException {
        try {
            return (T)DeepCopy.copy(object);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class DeepCopy {
        private DeepCopy() {
        }

        public static Object copy(Object orig) throws IOException, ClassNotFoundException {
            FastByteArrayOutputStream fbos = new FastByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(fbos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(fbos.getInputStream());
            return in.readObject();
        }
    }
}

