/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.FastByteArrayInputStream;
import com.ericsson.ere.util.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class CompressedString {
    private static char[] NULL = "null".toCharArray();
    public static final int LENGTH_THRESHOLD = 16384;
    private static final int FLATER_BUFFER_SIZE = 8192;
    private String myString;
    private transient String myPreview;
    private byte[] myCompressedData;
    private int myOriginalSize;
    private boolean myStringIsNull;
    private transient WeakReference<String> myDecompressedString;
    private transient WeakReference<char[]> myDecompressedChars;
    private transient int myDeflaterLevel;
    private transient int myPreviewLength;
    private transient int myHash;

    public CompressedString(String s) {
        this(s, 1);
    }

    public CompressedString(String s, int compressionLevel) {
        this(s, compressionLevel, 200);
    }

    public CompressedString(String s, int compressionLevel, int previewLength) {
        if (previewLength < 1) {
            throw new IllegalArgumentException("Preview size must be >= 1.");
        }
        if (compressionLevel != 9 && compressionLevel != 1 && compressionLevel != -1 && compressionLevel != 0) {
            throw new IllegalArgumentException("Invalid compression level.");
        }
        this.myPreviewLength = previewLength;
        this.myDeflaterLevel = compressionLevel;
        this.init(s);
    }

    private void init(String s) {
        if (s == null) {
            this.myStringIsNull = true;
        } else {
            this.myOriginalSize = s.length();
            if (this.myOriginalSize > 16384) {
                this.myPreview = this.buildPreview(s);
                try {
                    this.myCompressedData = this.compressString(s);
                }
                catch (IOException ex) {
                    throw new AssertionError((Object)ex);
                }
            } else {
                this.myString = s;
            }
        }
    }

    public String getPreview() {
        String preview = this.myStringIsNull ? "null" : (this.myPreview != null ? this.myPreview : this.buildPreview(this.myString));
        return preview;
    }

    private String buildPreview(String string) {
        int size = string.indexOf(10);
        if (size > 0 && string.charAt(size - 1) == '\r') {
            --size;
        }
        if (size < 0 || size > this.myPreviewLength) {
            size = Math.min(this.myPreviewLength, string.length());
        }
        return string.substring(0, size);
    }

    public int length() {
        return this.myStringIsNull ? 0 : this.myOriginalSize;
    }

    public int compressedLength() {
        return this.myCompressedData != null ? this.myCompressedData.length : 0;
    }

    private byte[] compressString(String s) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        DeflaterOutputStream zip = new DeflaterOutputStream((OutputStream)bos, new Deflater(this.myDeflaterLevel), 8192);
        OutputStreamWriter writer = new OutputStreamWriter(zip);
        writer.write(s);
        writer.flush();
        zip.finish();
        return bos.getByteArray();
    }

    private char[] decompressData() throws IOException {
        FastByteArrayInputStream bis = new FastByteArrayInputStream(this.myCompressedData, this.myCompressedData.length);
        InflaterInputStream zip = new InflaterInputStream(bis, new Inflater(), 8192);
        InputStreamReader reader = new InputStreamReader(zip);
        char[] chars = new char[this.myOriginalSize];
        reader.read(chars, 0, this.myOriginalSize);
        return chars;
    }

    public String toString() {
        String weak;
        String ret;
        if (this.myStringIsNull) {
            ret = "null";
        } else if (this.myCompressedData == null) {
            ret = this.myString;
        } else if (this.myDecompressedString != null && (weak = (String)this.myDecompressedString.get()) != null) {
            ret = weak;
        } else {
            try {
                ret = new String(this.decompressData());
                this.myDecompressedString = new WeakReference<String>(ret);
            }
            catch (IOException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        return ret;
    }

    public char[] toCharArray() {
        char[] weak;
        char[] ret;
        if (this.myStringIsNull) {
            ret = NULL;
        } else if (this.myCompressedData == null) {
            ret = this.myString.toCharArray();
        } else if (this.myDecompressedChars != null && (weak = (char[])this.myDecompressedChars.get()) != null) {
            ret = weak;
        } else {
            try {
                ret = this.decompressData();
                this.myDecompressedChars = new WeakReference<char[]>(ret);
            }
            catch (IOException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        return ret;
    }

    public int hashCode() {
        int result = this.myHash;
        if (result == 0) {
            result = this.myStringIsNull ? 0 : (this.myString != null ? this.myString.hashCode() : Arrays.hashCode(this.myCompressedData));
            this.myHash = result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompressedString other = (CompressedString)obj;
        if (this.myOriginalSize != other.myOriginalSize) {
            return false;
        }
        if (this.myString == null) {
            if (other.myString != null) {
                return false;
            }
            if (!Arrays.equals(this.myCompressedData, other.myCompressedData)) {
                return false;
            }
        } else {
            if (other.myString == null) {
                return false;
            }
            if (!this.myString.equals(other.myString)) {
                return false;
            }
        }
        return true;
    }
}

