/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.AbstractStrategyBasedObjectCloner;
import com.ericsson.ere.util.ArrayCloneStrategy;
import com.ericsson.ere.util.ArrayModelCloneStrategy;
import com.ericsson.ere.util.CloneKnownMutableStrategy;
import com.ericsson.ere.util.CloneViaCloneableStrategy;
import com.ericsson.ere.util.CloneViaCopyConstructorStrategy;
import com.ericsson.ere.util.CollectionCloneStrategy;
import com.ericsson.ere.util.DataTypeCloneStrategy;
import com.ericsson.ere.util.ItemListModelCloneStrategy;
import com.ericsson.ere.util.ObjectCloner;
import com.ericsson.ere.util.ReturnKnownImmutableStrategy;
import com.ericsson.ere.util.VariableCloneStrategy;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DefaultRMAObjectCloner
extends AbstractStrategyBasedObjectCloner {
    private final List<AbstractStrategyBasedObjectCloner.CloneStrategy> myStrategies;

    public DefaultRMAObjectCloner() {
        ArrayList<AbstractStrategyBasedObjectCloner.CloneStrategy> strategies = new ArrayList<AbstractStrategyBasedObjectCloner.CloneStrategy>();
        strategies.add(new ReturnKnownImmutableStrategy());
        strategies.add(new CloneKnownMutableStrategy());
        strategies.add(new ArrayModelCloneStrategy());
        strategies.add(new VariableCloneStrategy());
        strategies.add(new ItemListModelCloneStrategy());
        strategies.add(new ArrayCloneStrategy());
        strategies.add(new CollectionCloneStrategy());
        strategies.add(new CloneViaCloneableStrategy());
        strategies.add(new CloneViaCopyConstructorStrategy());
        strategies.add(new DataTypeCloneStrategy());
        this.myStrategies = Collections.unmodifiableList(strategies);
    }

    @Override
    protected List<AbstractStrategyBasedObjectCloner.CloneStrategy> strategies() {
        return this.myStrategies;
    }

    public static Object cloneVariableValue(ObjectCloner cloner, Variable var) {
        Object clone = null;
        if (var == null) {
            return null;
        }
        try {
            Object value = var.getValueObject();
            clone = cloner.cloneObject(value);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (clone == null) {
            clone = var.clone();
        }
        return clone;
    }
}

