/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.Predicate;
import com.ericsson.ere.util.Transformer;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteringCollection<T, U, V extends T>
extends AbstractCollection<U> {
    private final Iterable<V> myInnerCollection;
    private final Transformer<T, U> myTransformer;

    private FilteringCollection(Iterable<V> inner, Transformer<T, U> predicate) {
        this.myInnerCollection = inner;
        this.myTransformer = predicate;
    }

    public static <T, U, V extends T> Collection<U> transform(Collection<V> collection, Transformer<T, U> transformer) {
        return new FilteringCollection<T, U, V>(collection, transformer);
    }

    public static <T, V extends T> Collection<V> create(Collection<V> collection, Predicate<T> predicate) {
        PredicateBasedTransformer trans = new PredicateBasedTransformer(predicate);
        return new FilteringCollection(collection, trans);
    }

    @Override
    public Iterator<U> iterator() {
        return new TransformingIterator(this.myInnerCollection.iterator(), this.myTransformer);
    }

    @Override
    public int size() {
        int s;
        Iterator<U> it = this.iterator();
        for (s = 0; it.hasNext() && s < Integer.MAX_VALUE; ++s) {
            it.next();
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        Iterator<U> it = this.iterator();
        return !it.hasNext();
    }

    private static class PredicateBasedTransformer<T, V extends T>
    implements Transformer<V, V> {
        private Predicate<T> myPredicate;

        PredicateBasedTransformer(Predicate<T> pred) {
            this.myPredicate = pred;
        }

        @Override
        public V transform(V input) {
            return (V)(this.myPredicate.test(input) ? input : null);
        }
    }

    private static class TransformingIterator<T, U, V extends T>
    implements Iterator<U> {
        private Iterator<V> myIterator;
        private U myToken;
        private Transformer<T, U> myTransformer;

        private TransformingIterator(Iterator<V> iterator, Transformer<T, U> transformer) {
            this.myIterator = iterator;
            this.myTransformer = transformer;
            this.advance();
        }

        private void advance() {
            this.myToken = null;
            while (this.myIterator.hasNext()) {
                V item = this.myIterator.next();
                U replacement = this.myTransformer.transform(item);
                if (replacement == null) continue;
                this.myToken = replacement;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.myToken != null;
        }

        @Override
        public U next() {
            U ret = this.myToken;
            if (ret == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported on a transforming collection.");
        }
    }
}

