/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Optional;
import java.util.logging.Logger;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public final class HashUtil {
    private static final Logger myLogger = Logger.getLogger(HashUtil.class.getName());
    private static final int DEFAULT_SALT_LENGTH = 128;
    private static final int ITERATIONS = 1723;
    private static final int KEY_LENGTH = 512;

    private HashUtil() {
        new AssertionError();
    }

    private static Optional<String> generateSalt(int length) {
        byte[] salt = null;
        try {
            SecureRandom mySecureRandom = SecureRandom.getInstanceStrong();
            salt = new byte[length];
            mySecureRandom.nextBytes(salt);
            if (length < 1) {
                myLogger.finest("Salt length can not be less than 1.");
                return Optional.empty();
            }
        }
        catch (NoSuchAlgorithmException e) {
            myLogger.finest("Invalid algorithm.");
        }
        return Optional.of(Base64.getEncoder().encodeToString(salt));
    }

    private static Optional<String> generateSalt() {
        return HashUtil.generateSalt(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<String> hashPassword(char[] password, String salt) {
        PBEKeySpec spec = new PBEKeySpec(password, salt.getBytes(), 1723, 512);
        String saltedText = "";
        try {
            String ALGORITHM = "PBKDF2WithHmacSHA512";
            SecretKeyFactory fac = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            byte[] secret = fac.generateSecret(spec).getEncoded();
            saltedText = salt + ":" + Base64.getEncoder().encodeToString(secret);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            myLogger.finest("The choosen algorithm is faulty or invalid key.");
        }
        finally {
            spec.clearPassword();
        }
        return Optional.of(saltedText);
    }

    public static final String hash(char[] password) {
        return HashUtil.hashPassword(password, HashUtil.generateSalt().get()).get();
    }

    public static boolean verify(char[] password, String key) {
        String salt = key.split(":")[0];
        Optional<String> optEncrypted = HashUtil.hashPassword(password, salt);
        if (!optEncrypted.isPresent()) {
            return false;
        }
        return optEncrypted.get().equals(key);
    }
}

