/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import java.util.Enumeration;
import java.util.Iterator;

public class IterableEnumeration<T>
implements Iterable<T> {
    private Enumeration<T> myEnumeration;

    public static <U> Iterable<U> makeIterable(Enumeration<U> enumeration) {
        return new IterableEnumeration<U>(enumeration);
    }

    public IterableEnumeration(Enumeration<T> enumeration) {
        this.myEnumeration = enumeration;
    }

    @Override
    public Iterator<T> iterator() {
        return new EIterator<T>(this.myEnumeration);
    }

    private static class EIterator<U>
    implements Iterator<U> {
        private Enumeration<U> myEnum;

        EIterator(Enumeration<U> enumeration) {
            this.myEnum = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.myEnum.hasMoreElements();
        }

        @Override
        public U next() {
            return this.myEnum.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Enumeration cannot be modified.");
        }
    }
}

