/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.deployer;

import com.ericsson.lwac.application.DatabaseType;
import com.ericsson.lwac.deployer.BeanId;
import com.ericsson.lwac.versions.Version;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface ApplicationContext {
    public Object getThis();

    public String getApplicationName();

    default public File getApplicationRoot() {
        return new File("/opt/lwac/application");
    }

    @Deprecated
    default public File getTransientStorageDirectory() {
        return this.getTempDirectory().toFile();
    }

    default public Path getTempDirectory() {
        return Paths.get("/var/lwac/tmp", new String[0]);
    }

    default public File getPersistentStorageDirectory() {
        return new File("/var/lwac/persistent");
    }

    public DatabaseType getDatabaseType();

    public BeanId getBeanId();

    public List<String> getBoundNames();

    default public Set<String> getSharedModuleNames() {
        return Collections.emptySet();
    }

    public Optional<Version> getRuntimeVersion();
}

