/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.faultindication;

import com.ericsson.lwac.faultindication.FaultIndicationDescription;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class FaultIndication {
    private final String faultName;
    private final String faultyResource;
    private final String description;
    private final Long eventTime;
    private final Integer expiration;
    private final FaultIndicationDescription.Severity severity;
    private final Map<String, Object> additionalInformation;
    private static final Type additionalInformationType = new TypeToken<Map<String, Object>>(){}.getType();
    private static final Gson gson = new Gson();

    private FaultIndication(Builder faultIndicationBuilder) {
        this.faultName = Objects.requireNonNull(faultIndicationBuilder.faultName, "faultName can not be null");
        this.faultyResource = faultIndicationBuilder.faultyResource;
        this.severity = faultIndicationBuilder.severity;
        this.description = faultIndicationBuilder.description;
        this.eventTime = faultIndicationBuilder.eventTime;
        this.expiration = faultIndicationBuilder.expiration;
        this.additionalInformation = (Map)gson.fromJson(gson.toJson(faultIndicationBuilder.additionalInformation), additionalInformationType);
    }

    public Builder buildUpon() {
        Builder builder = Builder.newBuilder().faultName(this.faultName).faultyResource(this.faultyResource).severity(this.severity).description(this.description);
        this.getAdditionalInformation().ifPresent(e -> builder.additionalInformation((Map)gson.fromJson(gson.toJson(e), additionalInformationType)));
        this.getEventTime().ifPresent(builder::eventTime);
        this.getExpiration().ifPresent(builder::expiration);
        return builder;
    }

    public String getFaultName() {
        return this.faultName;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<FaultIndicationDescription.Severity> getSeverity() {
        return Optional.ofNullable(this.severity);
    }

    public Optional<String> getFaultyResource() {
        return Optional.ofNullable(this.faultyResource);
    }

    public Optional<Integer> getExpiration() {
        return Optional.ofNullable(this.expiration);
    }

    public Optional<Long> getEventTime() {
        return Optional.ofNullable(this.eventTime);
    }

    public Optional<Map<String, Object>> getAdditionalInformation() {
        return Optional.ofNullable(this.additionalInformation);
    }

    public static Builder newBuilder(FaultIndicationDescription faultIndicationDescription) {
        return new Builder(faultIndicationDescription);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaultIndication that = (FaultIndication)o;
        return this.getFingerprint().equals(that.getFingerprint());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getFaultName(), this.getFaultyResource().orElse(null), this.getDescription().orElse(null), this.getExpiration().orElse(-1), this.getSeverity().isPresent() ? this.getSeverity().get() : null, this.getAdditionalInformation().orElse(null)});
    }

    public String getFingerprint() {
        StringBuilder stringBuilder = new StringBuilder(this.getFaultName());
        this.getFaultyResource().ifPresent(stringBuilder::append);
        this.getDescription().ifPresent(stringBuilder::append);
        this.getExpiration().ifPresent(e -> stringBuilder.append(e.toString()));
        this.getSeverity().ifPresent(stringBuilder::append);
        this.getAdditionalInformation().ifPresent(e -> stringBuilder.append(e.toString()));
        String values = stringBuilder.toString();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(values.getBytes(Charset.defaultCharset()));
            return Base64.getEncoder().encodeToString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    public String getUniqueId() {
        StringBuilder stringBuilder = new StringBuilder(this.getFaultName());
        stringBuilder.append('|');
        this.getFaultyResource().ifPresent(stringBuilder::append);
        return stringBuilder.toString();
    }

    public static final class Builder {
        private String faultName;
        private String faultyResource;
        private String description;
        private Long eventTime;
        private Integer expiration;
        private FaultIndicationDescription.Severity severity;
        private Map<String, Object> additionalInformation;

        private Builder() {
        }

        private Builder(FaultIndicationDescription faultIndicationDescription) {
            this.faultName = faultIndicationDescription.getFaultName();
            this.description = faultIndicationDescription.getDefaultDescription();
            this.severity = faultIndicationDescription.getDefaultSeverity();
            this.expiration = faultIndicationDescription.getDefaultExpiration();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder faultName(String faultName) {
            this.faultName = faultName;
            return this;
        }

        public Builder faultyResource(String faultyResource) {
            this.faultyResource = faultyResource;
            return this;
        }

        public Builder severity(FaultIndicationDescription.Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder eventTime(long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public Builder expiration(int expiration) {
            this.expiration = expiration;
            return this;
        }

        public Builder additionalInformation(Map<String, Object> additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        public Builder additionalInformation(String key, Object value) {
            if (this.additionalInformation == null) {
                this.additionalInformation = new LinkedHashMap<String, Object>();
            }
            this.additionalInformation.put(key, value);
            return this;
        }

        public FaultIndication build() {
            return new FaultIndication(this);
        }
    }
}

