/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class BufferedOutputStream
extends OutputStream {
    public static final int BUFFER_SIZE = 8192;
    private final List<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
    private int lastBufferIndex = 0;

    public BufferedOutputStream() {
        this.buffers.add(ByteBuffer.allocate(8192));
    }

    public List<ByteBuffer> getBufferList() {
        return this.buffers;
    }

    @Override
    public void write(int b) {
        ByteBuffer buffer = this.buffers.get(this.lastBufferIndex);
        if (buffer.remaining() < 1) {
            buffer = ByteBuffer.allocate(8192);
            this.buffers.add(buffer);
            ++this.lastBufferIndex;
        }
        buffer.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        Objects.requireNonNull(b);
        ByteBuffer buffer = this.buffers.get(this.lastBufferIndex);
        int remaining = buffer.remaining();
        int offset = off;
        int length = len;
        while (length > remaining) {
            buffer.put(b, offset, remaining);
            length -= remaining;
            offset += remaining;
            buffer = ByteBuffer.allocate(8192);
            this.buffers.add(buffer);
            ++this.lastBufferIndex;
            remaining = buffer.remaining();
        }
        buffer.put(b, offset, length);
    }

    public int size() {
        int size = 0;
        for (ByteBuffer buf : this.buffers) {
            size += buf.limit();
        }
        return size;
    }

    public void flipBuffers() {
        for (ByteBuffer buffer : this.buffers) {
            ((Buffer)buffer).flip();
        }
    }
}

