/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.http.types.HttpOperationPath;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public final class HttpOperationRequest {
    private boolean consumed;
    private final InputStream inputStream;
    private final String signature;
    private final String sessionId;
    private final String context;
    private final HttpOperationPath httpOperationPath;
    private final HttpMethod httpMethod;
    private final String remoteHost;
    private final Map<String, String> headers;
    private final Map<String, String> parameters;
    private final String contentType;

    private HttpOperationRequest(InputStream inputStream, String signature, String sessionId, String context, HttpOperationPath httpOperationPath, HttpMethod httpMethod, String remoteHost, Map<String, String> headers, Map<String, String> parameters, String contentType) {
        this.inputStream = inputStream;
        this.signature = signature;
        this.sessionId = sessionId;
        this.context = context;
        this.httpOperationPath = httpOperationPath;
        this.httpMethod = httpMethod;
        this.remoteHost = remoteHost;
        this.headers = headers;
        this.parameters = parameters;
        this.contentType = contentType;
    }

    public InputStream getInputStream() {
        if (this.consumed) {
            throw new IllegalStateException("Already consumed");
        }
        this.consumed = true;
        return this.inputStream;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public HttpOperationPath getHttpOperationPath() {
        return this.httpOperationPath;
    }

    public String getContext() {
        return this.context;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getHeader(String headerName) {
        Optional<String> headerValue = Optional.ofNullable(this.headers.get(headerName));
        return headerValue.orElseGet(() -> this.getHeaderIgnoringCase(headerName));
    }

    private String getHeaderIgnoringCase(String headerName) {
        return this.getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().equals(headerName.toLowerCase())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getParameter(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public String getContentType() {
        return this.contentType;
    }

    public static HttpOperationRequestBuilder newBuilder() {
        return new HttpOperationRequestBuilder();
    }

    public static HttpOperationRequestBuilder buildUpon(HttpOperationRequest original) {
        HttpOperationRequestBuilder builder = HttpOperationRequest.newBuilder();
        builder.inputStream(original.getInputStream());
        builder.signature(original.getSignature());
        builder.sessionId(original.getSessionId());
        builder.httpOperationPath(original.getHttpOperationPath());
        builder.context(original.getContext());
        builder.httpMethod(original.getHttpMethod());
        builder.remoteHost(original.getRemoteHost());
        builder.contentType(original.getContentType());
        return builder;
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        TRACE,
        OPTIONS,
        CONNECT,
        PATCH;

    }

    public static class HttpOperationRequestBuilder {
        private InputStream inputStream;
        private String signature;
        private String sessionId;
        private String context;
        private HttpOperationPath httpOperationPath;
        private HttpMethod httpMethod = HttpMethod.POST;
        private String remoteHost;
        private Map<String, String> headers;
        private Map<String, String> parameters;
        private String contentType;

        public HttpOperationRequestBuilder inputStream(InputStream value) {
            this.inputStream = value;
            return this;
        }

        public HttpOperationRequestBuilder signature(String value) {
            this.signature = value;
            return this;
        }

        public HttpOperationRequestBuilder sessionId(String value) {
            this.sessionId = value;
            return this;
        }

        public HttpOperationRequestBuilder context(String value) {
            this.context = value;
            return this;
        }

        public HttpOperationRequestBuilder httpOperationPath(HttpOperationPath value) {
            this.httpOperationPath = value;
            return this;
        }

        public HttpOperationRequestBuilder httpMethod(HttpMethod value) {
            this.httpMethod = value;
            return this;
        }

        public HttpOperationRequestBuilder remoteHost(String value) {
            this.remoteHost = value;
            return this;
        }

        public HttpOperationRequestBuilder headers(Map<String, String> value) {
            this.headers = value;
            return this;
        }

        public HttpOperationRequestBuilder parameters(Map<String, String> value) {
            this.parameters = value;
            return this;
        }

        public HttpOperationRequestBuilder contentType(String value) {
            this.contentType = value;
            return this;
        }

        public HttpOperationRequest build() {
            HttpOperationRequest result = new HttpOperationRequest(this.inputStream, this.signature, this.sessionId, this.context, this.httpOperationPath, this.httpMethod, this.remoteHost, this.headers, this.parameters, this.contentType);
            return result;
        }
    }
}

