/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.http.core.HttpResponseCode;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class HttpOperationResponse {
    private final OutputStream outputStream;
    private final Map<String, String> headers = new HashMap<String, String>();
    private HttpResponseCode httpResponseCode = HttpResponseCode.HTTP_OK;

    private HttpOperationResponse(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setHttpResponseCode(HttpResponseCode httpResponseCode) {
        Objects.requireNonNull(httpResponseCode);
        this.httpResponseCode = httpResponseCode;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public HttpResponseCode getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public static HttpOperationResponseBuilder newBuilder() {
        return new HttpOperationResponseBuilder();
    }

    public static HttpOperationResponseBuilder buildUpon(HttpOperationResponse original) {
        HttpOperationResponseBuilder builder = HttpOperationResponse.newBuilder();
        builder.outputStream(original.getOutputStream());
        return builder;
    }

    public static class HttpOperationResponseBuilder {
        private OutputStream outputStream;

        public HttpOperationResponseBuilder outputStream(OutputStream value) {
            this.outputStream = value;
            return this;
        }

        public HttpOperationResponse build() {
            HttpOperationResponse result = new HttpOperationResponse(this.outputStream);
            return result;
        }
    }
}

