/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.cli.ApplicationProperties;
import com.ericsson.lwac.deployer.MainDeployer;
import com.ericsson.lwac.deployer.ObjectName;
import com.ericsson.lwac.deployer.OptionalDependency;
import com.ericsson.lwac.deployer.RequestContext;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.deployer.service.ServiceProperty;
import com.ericsson.lwac.http.BufferedOutputStream;
import com.ericsson.lwac.http.CallContext;
import com.ericsson.lwac.http.ContextAuthenticationManager;
import com.ericsson.lwac.http.HttpAuthenticationManager;
import com.ericsson.lwac.http.HttpOperation;
import com.ericsson.lwac.http.HttpOperationBase;
import com.ericsson.lwac.http.HttpOperationCallContext;
import com.ericsson.lwac.http.HttpOperationContainer;
import com.ericsson.lwac.http.HttpOperationHandler;
import com.ericsson.lwac.http.HttpOperationRequest;
import com.ericsson.lwac.http.HttpOperationResponse;
import com.ericsson.lwac.http.HttpOperationService;
import com.ericsson.lwac.http.HttpOperationServiceListener;
import com.ericsson.lwac.http.HttpUnauthorizedException;
import com.ericsson.lwac.http.LogoutOperation;
import com.ericsson.lwac.http.OperationBase;
import com.ericsson.lwac.http.OperationClassInfo;
import com.ericsson.lwac.http.RequestCorrelationId;
import com.ericsson.lwac.http.SessionType;
import com.ericsson.lwac.http.UnexpectedErrorHandler;
import com.ericsson.lwac.http.VersionResolver;
import com.ericsson.lwac.http.core.HttpBadRequestException;
import com.ericsson.lwac.http.core.HttpMethodNotAllowedException;
import com.ericsson.lwac.http.core.HttpNotAcceptableException;
import com.ericsson.lwac.http.core.HttpNotFoundException;
import com.ericsson.lwac.http.security.ServerSignerProvider;
import com.ericsson.lwac.http.trace.HttpTraceService;
import com.ericsson.lwac.http.types.HttpOperationPath;
import com.ericsson.lwac.http.types.NameVersion;
import com.ericsson.lwac.http.types.Version;
import com.ericsson.lwac.http.xml.GetContextDetailsOperation;
import com.ericsson.lwac.http.xml.GetFeaturesOperation;
import com.ericsson.lwac.http.xml.GetPermissionsOperation;
import com.ericsson.lwac.jobs.JobExecutorService;
import com.ericsson.lwac.monitoring.Measurement;
import com.ericsson.lwac.monitoring.StatisticsService;
import com.ericsson.lwac.net.CommunicationChannel;
import com.ericsson.lwac.net.CommunicationChannelManager;
import com.ericsson.lwac.net.http.BufferedHttpServletRequest;
import com.ericsson.lwac.net.http.HttpConnectorService;
import com.ericsson.lwac.net.http.HttpMessageProtocol;
import com.ericsson.lwac.otel.OpenTelemetryService;
import com.ericsson.lwac.otel.OperationAttributes;
import com.ericsson.lwac.otel.TracedIdentity;
import com.ericsson.lwac.registry.DotStringPart;
import com.ericsson.lwac.registry.Registry;
import com.ericsson.lwac.security.AuthenticationStatus;
import com.ericsson.lwac.security.authentication.AuthenticationErrorException;
import com.ericsson.lwac.security.authentication.AuthenticationFailedException;
import com.ericsson.lwac.security.authentication.AuthenticationProvider;
import com.ericsson.lwac.security.authentication.ChangeCredentialException;
import com.ericsson.lwac.security.authentication.InvalidCredentialException;
import com.ericsson.lwac.security.authentication.JwtAuthenticationProvider;
import com.ericsson.lwac.security.authentication.Secret;
import com.ericsson.lwac.security.authentication.SessionLimitExceededException;
import com.ericsson.lwac.security.authentication.StringSecret;
import com.ericsson.lwac.security.authentication.TOTPSetupProvider;
import com.ericsson.lwac.security.authentication.X509CertificateSecret;
import com.ericsson.lwac.security.authorization.AuthorizationErrorException;
import com.ericsson.lwac.security.authorization.AuthorizationFailedException;
import com.ericsson.lwac.security.authorization.AuthorizationService;
import com.ericsson.lwac.security.session.AuthenticationResult;
import com.ericsson.lwac.security.session.SessionContext;
import com.ericsson.lwac.security.session.SessionHeaders;
import com.ericsson.lwac.security.session.SessionManager;
import com.ericsson.lwac.utilities.Base64;
import com.ericsson.lwac.utilities.XffHeaderValidator;
import com.google.common.collect.ImmutableSet;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(serviceInterface=HttpMessageProtocol.class)
public class HttpOperationServiceBean
implements HttpOperationService {
    private Scope scope;
    private Span span;
    public static final String X_LWAC_HTTP_OPERATION_VERSIONS = "X-lwac-http-operation-versions";
    @Resource
    private Registry registry;
    @Resource
    private StatisticsService statisticsService;
    @Resource
    private SessionManager sessionManager;
    @Resource
    private MainDeployer mainDeployer;
    @Resource
    private RequestContext requestContext;
    @Resource
    private SessionContext sessionContext;
    @Resource
    private OpenTelemetryService openTelemetryService;
    @Resource
    private HttpTraceService httpTraceService;
    @EJB
    private CommunicationChannelManager communicationChannelManager;
    @EJB
    private ContextAuthenticationManager contextAuthenticationManager;
    @Resource
    @OptionalDependency
    private ApplicationProperties applicationProperties;
    @Resource
    private AuthorizationService authorizationService;
    private static final int PASSWORDHASHLENGTH = 6;
    private static final String SESSIONDATAKEY = "http-context";
    private static final Logger logger = LoggerFactory.getLogger(HttpOperationServiceBean.class);
    private Context directory;
    private final Map<NameVersion, HttpOperationBase> httpOperations = new ConcurrentHashMap<NameVersion, HttpOperationBase>();
    private List<OperationClassInfo> operationInfo;
    private String loginOperationClass;
    private HttpAuthenticationManager loginOperation;
    private String unexpectedErrorHandlerClass;
    private UnexpectedErrorHandler unexpectedErrorHandler;
    private String sessionContextName;
    private String cookieName = "sessionid";
    private boolean basicAuthSingleCall = true;
    private final List<HttpOperationServiceListener> listeners = new CopyOnWriteArrayList<HttpOperationServiceListener>();
    private final List<TOTPSetupProvider> totpSetupProviders = new CopyOnWriteArrayList<TOTPSetupProvider>();
    private AuthenticationProvider authenticationProvider;
    private ObjectName authenticationProviderName;
    private String httpConnectorName;
    private String versionResolverName;
    private VersionResolver versionResolver;
    private String signerProviderName;
    private ServerSignerProvider signerProvider;
    private boolean useQualifiedThreadNames = true;
    private boolean cookieSecure = true;
    private boolean cookieHttpOnly = true;
    private long failedAuthenticationTime = 0L;
    @Resource
    private JobExecutorService jobExecutorService;
    protected String context = "xml";
    protected List<String> operationClasses = new LinkedList<String>();
    protected final List<HttpOperationContainer> httpOperationContainers = new CopyOnWriteArrayList<HttpOperationContainer>();

    public HttpOperationServiceBean() {
    }

    HttpOperationServiceBean(MainDeployer mainDeployer, SessionManager sessionManager, RequestContext requestContext, Context context, StatisticsService statisticsService, SessionContext sessionContext, OpenTelemetryService openTelemetryService, HttpTraceService httpTraceService, CommunicationChannelManager communicationChannelManager, AuthorizationService authorizationService, ContextAuthenticationManager contextAuthenticationManager) {
        this.mainDeployer = mainDeployer;
        this.sessionManager = sessionManager;
        this.statisticsService = statisticsService;
        this.directory = context;
        this.requestContext = requestContext;
        this.sessionContext = sessionContext;
        this.openTelemetryService = openTelemetryService;
        this.httpTraceService = httpTraceService;
        this.communicationChannelManager = communicationChannelManager;
        this.authorizationService = authorizationService;
        this.contextAuthenticationManager = contextAuthenticationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> handleAsync(HttpServletRequest request, HttpServletResponse response) {
        CompletableFuture<Void> result;
        block29: {
            result = new CompletableFuture<Void>();
            RequestCorrelationId correlationId = new RequestCorrelationId();
            CallContext callContext = new CallContext(this.httpTraceService, (BufferedHttpServletRequest)request, response);
            this.httpTraceService.setStartTime();
            long startTime = System.nanoTime();
            String threadName = Thread.currentThread().getName();
            HttpOperationHandler operationHandler = new HttpOperationHandler(correlationId, this.signerProvider, this.listeners);
            String operationName = null;
            Version version = null;
            Measurement measurement = null;
            try {
                Span currentSpan;
                HttpOperationPath path = this.getHttpOperationPath(callContext);
                operationName = path.getOperationName();
                if (this.useQualifiedThreadNames) {
                    Thread.currentThread().setName(String.format("%s-%s/%s", threadName, this.context, path.getOperationName()));
                }
                version = this.getVersion(callContext.getRequest(), operationName);
                if (this.openTelemetryService.isTraceEnabled() && (currentSpan = Span.current()).getSpanContext().isValid()) {
                    currentSpan.setAttribute(OperationAttributes.OPERATION_CONTEXT, String.valueOf(path.getContext()));
                    currentSpan.setAttribute(OperationAttributes.OPERATION_NAME, operationName);
                    currentSpan.setAttribute(OperationAttributes.OPERATION_VERSION, String.valueOf(version));
                }
                this.parseCookies(callContext);
                measurement = this.statisticsService.startMeasurment("http", String.format("%s/%s/%s", this.context, operationName, version), StatisticsService.MeasurementType.INCOMING, StatisticsService.UsageType.PERFORMANCE);
                Map<String, String> headers = this.parseHeaders(callContext);
                String authorization = callContext.getRequest().getHeader("Authorization");
                this.validateEitherSessionOrAuthorization(callContext, authorization);
                ImmutableSet<String> hardCodedOperations = ImmutableSet.of("login", "secondarylogin", "changepassword", "logout", "ping");
                if (hardCodedOperations.contains(operationName)) {
                    switch (operationName) {
                        case "login": {
                            this.handleLogin(operationName, callContext);
                            this.handleIdentityTracing(request, path, operationName, version);
                            break;
                        }
                        case "secondarylogin": {
                            this.handleSecondaryLogin(operationName, callContext);
                            break;
                        }
                        case "changepassword": {
                            this.handleChangePassword(operationName, callContext, authorization);
                            break;
                        }
                        case "logout": {
                            this.handleLogout(callContext);
                            break;
                        }
                        case "ping": {
                            this.handlePing(callContext);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported default method " + operationName);
                        }
                    }
                    if (measurement != null) {
                        this.statisticsService.stopMeasurement(measurement);
                    }
                    break block29;
                }
                HttpOperationBase operation = this.getOperation(operationName, version);
                if (!this.handleAuthentication(callContext, authorization, operation)) {
                    this.setErrorOrFailureOnMeasurement(measurement, false);
                    this.finalizeRequest(callContext, measurement);
                    result.complete(null);
                    CompletableFuture<Void> completableFuture = result;
                    return completableFuture;
                }
                this.handleIdentityTracing(request, path, operationName, version);
                CompletionStage completionStage = ((CompletableFuture)operationHandler.handle(path, callContext, operation, headers).thenAccept(v -> {
                    this.handleCookieSecure(response);
                    this.handleCookieHttpOnly(response);
                })).handle(this.handleAction(correlationId, callContext, operationName, version, startTime, measurement));
                return completionStage;
            }
            catch (Throwable throwable) {
                Measurement tmpMeasurement = measurement;
                CompletionStage completionStage = this.handleThrowable(correlationId, operationName, version, measurement, startTime, callContext, throwable).thenAccept(unused -> this.finalizeRequest(callContext, tmpMeasurement));
                return completionStage;
            }
            finally {
                if (this.openTelemetryService.isTraceEnabled()) {
                    this.openTelemetryService.stopForcingSpans();
                    if (this.span != null) {
                        this.span.end();
                    }
                    if (this.scope != null) {
                        this.scope.close();
                    }
                }
                if (this.useQualifiedThreadNames) {
                    Thread.currentThread().setName(threadName);
                }
                this.sessionManager.reset();
                this.requestContext.reset();
            }
        }
        result.complete(null);
        return result;
    }

    private void handleIdentityTracing(HttpServletRequest request, HttpOperationPath path, String operationName, Version version) {
        boolean suppressTracing;
        if (!this.openTelemetryService.isTraceEnabled()) {
            return;
        }
        if (this.sessionContext.isSessionExisting()) {
            TracedIdentity realUser = new TracedIdentity(this.sessionContext.getRealUser().getUserId(), this.sessionContext.getRealUser().getUserIdType());
            TracedIdentity effectiveUser = new TracedIdentity(this.sessionContext.getEffectiveUser().getUserId(), this.sessionContext.getEffectiveUser().getUserIdType());
            if (this.openTelemetryService.isTraced(effectiveUser) || this.openTelemetryService.isTraced(realUser)) {
                this.openTelemetryService.startForcingSpans();
            }
        }
        boolean bl = suppressTracing = request.getRequestURI().startsWith("/invoker") || request.getRequestURI().startsWith("/httpsimulator");
        if (!suppressTracing && this.openTelemetryService != null) {
            ThreadLocal<Boolean> forceSpans;
            boolean isSampled = Span.current().getSpanContext().isSampled();
            if (!isSampled) {
                String name = request.getMethod() + " " + request.getRequestURI();
                Attributes attributes = Attributes.builder().put(HttpAttributes.HTTP_REQUEST_METHOD, request.getMethod()).put(UrlAttributes.URL_PATH, request.getRequestURI()).put(OperationAttributes.BEAN_CLASS, HttpOperationService.class.getSimpleName()).put(OperationAttributes.OPERATION_CONTEXT, String.valueOf(path.getContext())).put(OperationAttributes.OPERATION_NAME, String.valueOf(operationName)).put(OperationAttributes.OPERATION_VERSION, String.valueOf(version)).build();
                this.span = this.openTelemetryService.startServerSpan(name, null, attributes);
                this.scope = this.span.makeCurrent();
            }
            if ((forceSpans = this.openTelemetryService.getForceSpans()) != null && forceSpans.get().booleanValue()) {
                logger.info("current trace is forced by OpenTelemetry identity tracing");
            }
        }
    }

    private BiFunction<Void, Throwable, Void> handleAction(RequestCorrelationId correlationId, HttpOperationCallContext callContext, String operationName, Version version, long startTime, Measurement measurement) {
        return (v, t) -> {
            this.handleThrowable(correlationId, operationName, version, measurement, startTime, callContext, (Throwable)t).thenAccept(n -> this.finalizeRequest(callContext, measurement));
            return null;
        };
    }

    protected void finalizeRequest(HttpOperationCallContext callContext, Measurement measurement) {
        try {
            if (measurement != null) {
                this.statisticsService.stopMeasurement(measurement);
            }
            if (this.sessionContext.getCurrentSession() != null) {
                this.httpTraceService.setSession(this.sessionContext.getCurrentSession().getSessionId());
            }
            if (callContext.isSingleCallLogin()) {
                this.sessionManager.logout(callContext.getSessionId(), this.sessionContextName);
            }
            this.httpTraceService.logRequest(callContext);
            this.httpTraceService.logResponse(callContext);
            callContext.finishResponse();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected CompletableFuture<Void> handleThrowable(RequestCorrelationId correlationId, String operationName, Version version, Measurement measurement, long startTime, HttpOperationCallContext callContext, Throwable throwable) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        result.complete(null);
        if (throwable == null) {
            return result;
        }
        try {
            Throwable cause = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            BufferedOutputStream errorStream = new BufferedOutputStream();
            if (cause instanceof HttpUnauthorizedException) {
                this.setErrorOrFailureOnMeasurement(measurement, false);
                this.writePlainTextMessage(callContext, errorStream, cause.getMessage());
                callContext.setStatus(401);
            } else if (cause instanceof HttpNotFoundException) {
                logger.debug("Http not found {}", (Object)cause.getMessage());
                this.setErrorOrFailureOnMeasurement(measurement, false);
                errorStream = new BufferedOutputStream();
                callContext.setStatus(404);
            } else if (cause instanceof HttpBadRequestException) {
                this.setErrorOrFailureOnMeasurement(measurement, false);
                errorStream = new BufferedOutputStream();
                logger.trace("Bad request", cause);
                HttpBadRequestException httpBadRequestException = (HttpBadRequestException)cause;
                if (httpBadRequestException.getBody().isPresent()) {
                    callContext.setContentType(httpBadRequestException.getContentType().orElse("text/plain") + "; charset=UTF-8");
                    errorStream.write(((String)httpBadRequestException.getBody().get()).getBytes(StandardCharsets.UTF_8));
                }
                callContext.setStatus(400);
            } else if (cause instanceof HttpMethodNotAllowedException) {
                logger.trace("Method not allowed", cause);
                this.setErrorOrFailureOnMeasurement(measurement, false);
                errorStream = new BufferedOutputStream();
                callContext.setStatus(405);
            } else if (cause instanceof HttpNotAcceptableException) {
                logger.trace("Request not acceptable", cause);
                this.setErrorOrFailureOnMeasurement(measurement, false);
                errorStream = new BufferedOutputStream();
                callContext.setStatus(406);
            } else if (cause instanceof SessionLimitExceededException) {
                this.setErrorOrFailureOnMeasurement(measurement, false);
                errorStream = new BufferedOutputStream();
                callContext.setResponseHeader("WWW-Authenticate", "Basic realm=\"\"");
                this.writePlainTextMessage(callContext, errorStream, "session limit exceeded");
                callContext.setStatus(401);
            } else if (cause instanceof AuthenticationErrorException) {
                this.setErrorOrFailureOnMeasurement(measurement, true);
                errorStream = new BufferedOutputStream();
                callContext.setResponseHeader("WWW-Authenticate", "Basic realm=\"\"");
                this.writePlainTextMessage(callContext, errorStream, cause.getMessage());
                callContext.setStatus(401);
                logger.error("Authentication error", cause);
                result = this.handleDeferredResponse(startTime);
            } else if (cause instanceof AuthenticationFailedException) {
                this.setErrorOrFailureOnMeasurement(measurement, false);
                errorStream = new BufferedOutputStream();
                callContext.setResponseHeader("WWW-Authenticate", "Basic realm=\"\"");
                this.writePlainTextMessage(callContext, errorStream, "Authentication Failed");
                callContext.setStatus(401);
                logger.debug("Authentication failed", cause);
                result = this.handleDeferredResponse(startTime);
            } else if (cause instanceof InvalidCredentialException) {
                this.setErrorOrFailureOnMeasurement(measurement, false);
                errorStream = new BufferedOutputStream();
                callContext.setResponseHeader("WWW-Authenticate", "Basic realm=\"\"");
                this.writePlainTextMessage(callContext, errorStream, cause.getMessage());
                callContext.setStatus(401);
                logger.debug("Change credential failed", cause);
                result = this.handleDeferredResponse(startTime);
            } else if (cause instanceof AuthorizationErrorException) {
                this.setErrorOrFailureOnMeasurement(measurement, true);
                errorStream = new BufferedOutputStream();
                callContext.setStatus(403);
                logger.error("Authorization error", cause);
            } else if (cause instanceof AuthorizationFailedException) {
                this.setErrorOrFailureOnMeasurement(measurement, false);
                errorStream = new BufferedOutputStream();
                callContext.setStatus(403);
                logger.debug("Authorization failed", cause);
            } else if (cause instanceof SecurityException) {
                this.setErrorOrFailureOnMeasurement(measurement, false);
                errorStream = new BufferedOutputStream();
                callContext.setStatus(403);
                logger.debug("Unauthorized access", cause);
            } else {
                if (cause instanceof IOException) {
                    this.setErrorOrFailureOnMeasurement(measurement, true);
                    callContext.setStatus(500);
                    logger.error("Unexpected io error in http operation service", cause);
                    result.completeExceptionally(cause);
                    throw (IOException)cause;
                }
                if (cause instanceof ChangeCredentialException) {
                    this.setErrorOrFailureOnMeasurement(measurement, true);
                    errorStream = new BufferedOutputStream();
                    this.writePlainTextMessage(callContext, errorStream, cause.getMessage() != null ? cause.getMessage() : "CHANGE_CREDENTIAL_FAILED");
                    callContext.setStatus(500);
                    logger.debug("Change credential failed", cause);
                } else if (cause instanceof Exception) {
                    this.setErrorOrFailureOnMeasurement(measurement, true);
                    callContext.setContentType(this.unexpectedErrorHandler.getContentType());
                    errorStream = new BufferedOutputStream();
                    this.unexpectedErrorHandler.handle(correlationId, operationName, version, errorStream, (Exception)cause);
                    callContext.setStatus(500);
                } else {
                    this.setErrorOrFailureOnMeasurement(measurement, true);
                    logger.error("Unexpected error in http operation service", cause);
                    errorStream = new BufferedOutputStream();
                    callContext.setStatus(500);
                }
            }
            errorStream.flipBuffers();
            callContext.getResponseOutputStream().close();
            callContext.setResponseOutputStream(errorStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return result;
    }

    private CompletableFuture<Void> handleDeferredResponse(long startTime) {
        CompletableFuture<Void> waitFuture = new CompletableFuture<Void>();
        long waitTime = this.failedAuthenticationTime - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        if (waitTime > 0L) {
            this.jobExecutorService.schedule(null, () -> {
                waitFuture.complete(null);
                return null;
            }, waitTime, TimeUnit.MILLISECONDS);
        } else {
            waitFuture.complete(null);
        }
        return waitFuture;
    }

    protected HttpOperationPath getHttpOperationPath(HttpOperationCallContext callContext) {
        HttpOperationPath path = HttpOperationPath.create(callContext.getRequest().getRequestURI(), callContext.getRequest().getQueryString());
        if (!this.context.equals(path.getContext())) {
            throw new HttpBadRequestException(String.format("Could not parse request uri %s", callContext.getRequest().getRequestURI()));
        }
        return path;
    }

    protected void validateEitherSessionOrAuthorization(HttpOperationCallContext callContext, String authorization) {
        if (callContext.getSessionId() != null && authorization != null) {
            throw new HttpUnauthorizedException("Ambiguous session, got session id and Authorization header");
        }
    }

    protected void parseCookies(HttpOperationCallContext callContext) {
        if (callContext.getRequest().getCookies() != null) {
            for (Cookie cookie : callContext.getRequest().getCookies()) {
                if (!cookie.getName().equals(this.cookieName)) continue;
                callContext.setSessionId(cookie.getValue());
            }
        }
    }

    protected Map<String, String> parseHeaders(HttpOperationCallContext callContext) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration<String> headerNames = callContext.getRequest().getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            String headerValue = callContext.getRequest().getHeader(headerName);
            headers.put(headerName, headerValue);
            if (headerName.toLowerCase().startsWith("x-lwac-") || "x-request-id".equalsIgnoreCase(headerName)) {
                this.requestContext.add(headerName, headerValue);
            }
            if (!headerName.equals("Accept")) continue;
            if (this.requestContext.get(headerName) != null) {
                throw new HttpBadRequestException("Duplicate Accept header");
            }
            this.requestContext.add(headerName, headerValue);
        }
        return headers;
    }

    private void handleLogin(String operationName, HttpOperationCallContext callContext) throws HttpNotFoundException, IOException, AuthenticationErrorException, AuthenticationFailedException, SessionLimitExceededException {
        if (this.loginOperation == null) {
            throw new HttpNotFoundException("Path not found " + operationName);
        }
        HttpAuthenticationManager.PrimaryLoginInformation primaryLoginInformation = this.loginOperation.primaryLogin(callContext.getRequest());
        SessionHeaders sessionHeaders = HttpOperationServiceBean.getSessionHeaders(callContext.getRequest());
        AuthenticationResult result = this.sessionManager.loginPrimary(this.authenticationProviderName, this.sessionContextName, primaryLoginInformation.getUserId(), primaryLoginInformation.getCredential(), true, sessionHeaders, new SessionManager.SessionData(SESSIONDATAKEY, this.context, true));
        this.handleAuthenticationResult(callContext, result);
    }

    private void handleSecondaryLogin(String operationName, HttpOperationCallContext callContext) throws HttpNotFoundException, IOException, AuthenticationErrorException, AuthenticationFailedException, SessionLimitExceededException {
        if (this.loginOperation == null) {
            throw new HttpNotFoundException("Path not found " + operationName);
        }
        HttpAuthenticationManager.SecondaryLoginInformation secondaryLoginInformation = this.loginOperation.secondaryLogin(callContext.getRequest());
        SessionHeaders sessionHeaders = HttpOperationServiceBean.getSessionHeaders(callContext.getRequest());
        AuthenticationResult result = this.sessionManager.loginSecondary(this.authenticationProviderName, this.sessionContextName, callContext.getSessionId(), secondaryLoginInformation.getCredential(), secondaryLoginInformation.getAuthType(), sessionHeaders);
        this.handleAuthenticationResult(callContext, result);
    }

    private void handleChangePassword(String operationName, CallContext callContext, String authorization) throws HttpNotFoundException, IOException, AuthenticationFailedException, SessionLimitExceededException, AuthenticationErrorException, ChangeCredentialException, InvalidCredentialException {
        if (this.loginOperation == null) {
            throw new HttpNotFoundException("Path not found " + operationName);
        }
        if (!(!this.authenticationProvider.requireSessionForChangingCredential() && callContext.getSessionId() == null || this.authenticate(callContext, authorization, operationName) || callContext.isFailure())) {
            return;
        }
        HttpAuthenticationManager.ChangePasswordInformation changePasswordInformation = this.loginOperation.changePassword(callContext.getRequest());
        String identity = changePasswordInformation.getIdentity();
        Secret currentSecret = changePasswordInformation.getCredential();
        Secret newSecret = changePasswordInformation.getNewCredential();
        Secret newSecretRepeated = changePasswordInformation.getNewCredentialRepeated();
        if (callContext.getSessionId() != null) {
            SessionHeaders sessionHeaders = HttpOperationServiceBean.getSessionHeaders(callContext.getRequest());
            AuthenticationResult result = this.sessionManager.changeCredential(this.authenticationProviderName, this.sessionContextName, callContext.getSessionId(), identity, currentSecret, newSecret, newSecretRepeated, sessionHeaders);
            this.handleAuthenticationResult(callContext, result);
        } else {
            this.authenticationProvider.changeCredential(null, identity, currentSecret, newSecret, newSecretRepeated);
            callContext.setStatus(200);
            callContext.markResponseFinished();
            callContext.closeOutputStream();
        }
    }

    private void handlePing(HttpOperationCallContext callContext) throws IOException {
        callContext.setStatus(200);
        callContext.setContentType("text/plain");
        callContext.getResponseOutputStream().write("PONG".getBytes(StandardCharsets.UTF_8));
        callContext.markResponseFinished();
        callContext.closeOutputStream();
    }

    private void handleLogout(HttpOperationCallContext callContext) throws IOException {
        if (callContext.getSessionId() == null) {
            throw new HttpUnauthorizedException("Missing session id");
        }
        Optional<Long> sessionIdFromToken = this.sessionManager.getSessionIdFromToken(callContext.getSessionId());
        sessionIdFromToken.ifPresent(aLong -> this.httpTraceService.setSession((long)aLong));
        this.sessionManager.logout(callContext.getSessionId(), this.sessionContextName);
        for (Cookie cookie : callContext.getRequest().getCookies()) {
            if (!cookie.getName().equals(this.cookieName)) continue;
            cookie.setMaxAge(0);
            cookie.setValue("");
            callContext.addCookie(cookie);
        }
        callContext.markResponseFinished();
        callContext.closeOutputStream();
    }

    private void handleCookieHttpOnly(HttpServletResponse response) {
        if (this.cookieHttpOnly) {
            response.getHeaderNames().forEach(headerName -> {
                if ("Set-Cookie".equalsIgnoreCase((String)headerName)) {
                    Object headerValue = response.getHeader((String)headerName);
                    headerValue = (String)headerValue + "; HttpOnly";
                    response.setHeader((String)headerName, (String)headerValue);
                }
            });
        }
    }

    private void handleCookieSecure(HttpServletResponse response) {
        if (this.cookieSecure) {
            response.getHeaderNames().forEach(headerName -> {
                if ("Set-Cookie".equalsIgnoreCase((String)headerName)) {
                    Object headerValue = response.getHeader((String)headerName);
                    headerValue = (String)headerValue + "; secure";
                    response.setHeader((String)headerName, (String)headerValue);
                }
            });
        }
    }

    private void writePlainTextMessage(HttpOperationCallContext callContext, BufferedOutputStream errorStream, String msg) throws IOException {
        callContext.setContentType("text/plain; charset=UTF-8");
        if (msg != null) {
            errorStream.write(msg.getBytes(StandardCharsets.UTF_8));
        } else {
            errorStream.write("unauthorized".getBytes(StandardCharsets.UTF_8));
        }
    }

    protected boolean handleAuthentication(HttpOperationCallContext callContext, String authorization, OperationBase operation) throws IOException, SessionLimitExceededException, AuthenticationErrorException, AuthorizationFailedException, AuthorizationErrorException, AuthenticationFailedException {
        String effectiveUser;
        if (operation.getSessionType() == SessionType.REQUIRES_SESSION) {
            if (!this.authenticate(callContext, authorization, operation.getName()) && !callContext.isFailure()) {
                return false;
            }
        } else if (operation.getSessionType() == SessionType.UNAUTHENTICATED_SESSION) {
            if (!this.authenticateUnauthorizedSession(callContext, authorization) && !callContext.isFailure()) {
                return false;
            }
        } else {
            SessionHeaders sessionHeaders = HttpOperationServiceBean.getSessionHeaders(callContext.getRequest());
            callContext.setSessionId(this.sessionManager.loginWithOutPermissions(this.sessionContextName, "unknown", sessionHeaders).getSessionToken());
            callContext.setSingleCallLogin(true);
        }
        if ((effectiveUser = this.requestContext.get("X-lwac-execute-as")) != null) {
            this.sessionManager.setEffectiveUser(effectiveUser);
        }
        return true;
    }

    private boolean authenticateUnauthorizedSession(HttpOperationCallContext callContext, String authorization) {
        boolean authenticated = false;
        try {
            if (callContext.getSessionId() != null) {
                this.sessionManager.resumeUnauthenticatedSession(callContext.getSessionId(), this.sessionContextName);
                if (this.sessionContext.getCurrentSession().getSessionData(SESSIONDATAKEY) != null && this.sessionContext.getCurrentSession().getSessionData(SESSIONDATAKEY).equals(this.context)) {
                    authenticated = true;
                }
            } else if (authorization != null) {
                this.authorizationService.resumeUnauthenticatedBearerToken(authorization.replaceFirst("Bearer ", ""), this.context);
                authenticated = true;
            }
        }
        catch (AuthenticationErrorException | SecurityException exception) {
            // empty catch block
        }
        if (!authenticated) {
            callContext.setResponseHeader("WWW-Authenticate", "Basic realm=\"\"");
            callContext.setStatus(401);
            callContext.markResponseFinished();
            callContext.setFailure(false);
        }
        return authenticated;
    }

    private void setErrorOrFailureOnMeasurement(Measurement measurement, boolean isError) {
        if (measurement != null) {
            if (isError) {
                measurement.setError();
            } else {
                measurement.setFailure();
            }
        }
    }

    private boolean authenticate(HttpOperationCallContext callContext, String authorization, String operationName) throws IOException, AuthenticationFailedException, AuthenticationErrorException, SessionLimitExceededException {
        boolean authenticated = false;
        try {
            if (callContext.getSessionId() != null && this.isAllowedOperationWhenTotpSetup(callContext.getSessionId(), operationName)) {
                this.sessionManager.resumeSession(callContext.getSessionId(), this.sessionContextName);
                if (this.sessionContext.getCurrentSession().getSessionData(SESSIONDATAKEY) != null && this.sessionContext.getCurrentSession().getSessionData(SESSIONDATAKEY).equals(this.context)) {
                    authenticated = true;
                }
            }
        }
        catch (AuthenticationErrorException authenticationErrorException) {
            // empty catch block
        }
        if (!authenticated && authorization != null) {
            if (authorization.startsWith("Basic ")) {
                SessionHeaders sessionHeaders;
                String password;
                String userPasswordBase64 = authorization.substring(6);
                String userPassword = new String(Base64.decode(userPasswordBase64), StandardCharsets.ISO_8859_1);
                int index = userPassword.indexOf(58);
                if (index == -1) {
                    throw new HttpUnauthorizedException("Parse error, authorization header");
                }
                String userID = userPassword.substring(0, index);
                AuthenticationResult result = this.sessionManager.loginPrimary(this.authenticationProviderName, this.sessionContextName, userID, new StringSecret(password = userPassword.substring(index + 1)), !this.basicAuthSingleCall, sessionHeaders = HttpOperationServiceBean.getSessionHeaders(callContext.getRequest()), new SessionManager.SessionData(SESSIONDATAKEY, this.context, true));
                if (result.getAuthenticationStatus() == AuthenticationStatus.CREDENTIAL_EXPIRED || result.getAuthenticationStatus() == AuthenticationStatus.CREDENTIAL_MUST_BE_CHANGED) {
                    this.handleAuthenticationResult(callContext, result);
                    return authenticated;
                }
                if (this.basicAuthSingleCall) {
                    callContext.setSessionId(result.getSessionToken());
                    callContext.setSingleCallLogin(true);
                } else {
                    this.setSessionInfo(callContext, result.getSessionToken());
                }
            } else if (authorization.startsWith("Bearer ")) {
                this.authorizationService.validateOperationAndResumeBearerToken(authorization.substring(7), operationName, this.context);
            } else {
                throw new HttpUnauthorizedException("Parse error, authorization header");
            }
            authenticated = true;
        }
        X509Certificate[] certs = (X509Certificate[])callContext.getRequest().getAttribute("jakarta.servlet.request.X509Certificate");
        String certData = callContext.getRequest().getHeader("ssl-client-cert");
        if (certs == null && certData != null) {
            String decoded = URLDecoder.decode(certData, StandardCharsets.UTF_8.name());
            try {
                CertificateFactory fact = CertificateFactory.getInstance("X.509");
                certs = new X509Certificate[]{(X509Certificate)fact.generateCertificate(new ByteArrayInputStream(decoded.getBytes()))};
            }
            catch (CertificateException e) {
                throw new AuthenticationFailedException("Could not parse client certificate", e);
            }
        }
        if (!authenticated && certs != null) {
            X509CertificateSecret certSecret = new X509CertificateSecret(certs);
            SessionHeaders sessionHeaders = HttpOperationServiceBean.getSessionHeaders(callContext.getRealRequest());
            AuthenticationResult result = this.sessionManager.loginPrimary(this.authenticationProviderName, this.sessionContextName, null, certSecret, true, sessionHeaders, new SessionManager.SessionData(SESSIONDATAKEY, this.context, true));
            this.setSessionInfo(callContext, result.getSessionToken());
            authenticated = true;
        }
        if (!authenticated) {
            callContext.setResponseHeader("WWW-Authenticate", "Basic realm=\"\"");
            callContext.setStatus(401);
            callContext.markResponseFinished();
            callContext.setFailure(false);
        }
        return authenticated;
    }

    private boolean isAllowedOperationWhenTotpSetup(String sessionId, String operationName) {
        if (this.sessionManager.isTotpSetupActive(sessionId)) {
            boolean allowed = false;
            for (TOTPSetupProvider provider : this.totpSetupProviders) {
                if (provider.getOperationName() == null || !provider.getOperationName().equalsIgnoreCase(operationName)) continue;
                allowed = true;
            }
            return allowed;
        }
        return true;
    }

    private static SessionHeaders getSessionHeaders(HttpServletRequest request) {
        XffHeaderValidator xffHeaderValidator = new XffHeaderValidator();
        String xffAddresses = xffHeaderValidator.createModifiedXffString(request.getHeaders("X-Forwarded-For"));
        if (xffAddresses != null && !xffHeaderValidator.isIpAddresses(xffAddresses)) {
            xffAddresses = null;
        }
        return SessionHeaders.builder().xffAddresses(xffAddresses).create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAuthenticationResult(HttpOperationCallContext callContext, AuthenticationResult result) throws IOException, AuthenticationFailedException {
        if (this.sessionContext.isSessionExisting()) {
            this.sessionContext.getCurrentSession().setSessionData(SESSIONDATAKEY, this.context, true);
        }
        this.setSessionInfo(callContext, result.getSessionToken());
        try {
            switch (result.getAuthenticationStatus()) {
                case SUCCESS: {
                    return;
                }
                case CREDENTIAL_MUST_BE_CHANGED: 
                case CREDENTIAL_EXPIRED: {
                    this.setRedirectResponse("/%s/changepassword", callContext);
                    return;
                }
                case CHALLENGE_REQUIRED: {
                    callContext.setContentType("text/plain");
                    callContext.getResponseOutputStream().write("PONG".getBytes(StandardCharsets.UTF_8));
                    return;
                }
                case OTP_REQUIRED: {
                    this.setRedirectResponse("/%s/secondarylogin", callContext);
                    return;
                }
                case TOTP_REQUIRED: {
                    this.setRedirectResponse("/%s/secondarylogin?authstep=totp", callContext);
                    return;
                }
                case TOTP_REGENERATE: {
                    this.setRedirectResponse("/%s/secondarylogin?authstep=totp_reset", callContext);
                    return;
                }
                case TOTP_SETUP: {
                    this.setRedirectResponse("/%s/generatetotpkey", callContext);
                    return;
                }
                default: {
                    throw new AuthenticationFailedException();
                }
            }
        }
        finally {
            callContext.markResponseFinished();
            callContext.closeOutputStream();
        }
    }

    private void setRedirectResponse(String redirectPath, HttpOperationCallContext callContext) throws IOException {
        callContext.sendRedirect(String.format(redirectPath, this.context));
    }

    private HttpOperationBase getOperation(final String operationName, final Version version) throws HttpNotFoundException {
        HttpOperationBase operation = this.httpOperations.get(new NameVersion(operationName, version));
        if (operation == null) {
            logger.warn("The operation {} with version {} was not found", (Object)operationName, (Object)version.toString());
            return new HttpOperation(){

                @Override
                @Nonnull
                public String getName() {
                    return operationName;
                }

                @Override
                public void handle(RequestCorrelationId requestCorrelationId, HttpOperationRequest httpOperationRequest, HttpOperationResponse htOperationResponse) throws Exception {
                    throw new HttpNotFoundException("Path not found " + operationName + " v" + String.valueOf(version));
                }

                @Override
                @Nonnull
                public String getContentType() {
                    return "text/plain; charset=UTF-8";
                }

                @Override
                @Nonnull
                public SessionType getSessionType() {
                    return SessionType.REQUIRES_SESSION;
                }
            };
        }
        return operation;
    }

    private Version getVersion(HttpServletRequest httpServletRequest, String operationName) throws HttpNotFoundException, HttpBadRequestException {
        if (this.versionResolver != null) {
            Version version = this.versionResolver.resolve(httpServletRequest);
            if (version == null) {
                throw new HttpNotFoundException(String.format("Could not find version for operation %s/%s", this.context, operationName));
            }
            return version;
        }
        return Version.DEFAULT_VERSION;
    }

    private void setSessionInfo(HttpOperationCallContext callContext, String sessionToken) {
        callContext.addCookie(new Cookie(this.cookieName, sessionToken));
        callContext.setStatus(200);
    }

    String[] processRequestURI(String requestString) {
        String result = requestString;
        while (result.startsWith("/") && result.length() > 1) {
            result = result.substring(1);
        }
        while (result.endsWith("/") && result.length() > 1) {
            result = result.substring(0, result.length() - 1);
        }
        return result.split("/");
    }

    boolean verifyRequestString(String requestString) {
        return !requestString.isEmpty() && requestString.length() >= this.context.length();
    }

    public void setLoginOperationClass(String loginOperation) {
        this.loginOperationClass = loginOperation;
    }

    @Override
    public void setHttpConnectorName(String httpConnectorName) {
        this.httpConnectorName = httpConnectorName;
    }

    public void setOperationClasses(List<String> operations) {
        this.operationClasses = operations;
    }

    public void setContext(String context) {
        this.context = context;
    }

    @ServiceProperty
    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    @ServiceProperty
    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setUnexpectedErrorHandlerClass(String unexpectedErrorHandlerClass) {
        this.unexpectedErrorHandlerClass = unexpectedErrorHandlerClass;
    }

    @Override
    public String getContext() {
        return "/" + this.context;
    }

    public void setBasicAuthSingleCall(boolean basicAuthSingleCall) {
        this.basicAuthSingleCall = basicAuthSingleCall;
    }

    @Override
    public void onStart() throws Exception {
        if (this.authenticationProviderName != null) {
            this.authenticationProvider = (AuthenticationProvider)this.directory.lookup(this.authenticationProviderName.getValueAsString());
            if (this.authorizationService != null) {
                if (this.authenticationProvider instanceof JwtAuthenticationProvider) {
                    this.authorizationService.register(this.context, (JwtAuthenticationProvider)this.authenticationProvider);
                } else {
                    logger.info("Authentication provider {} do not support JWT, skipping registration", (Object)this.authenticationProviderName);
                }
            }
            if (this.contextAuthenticationManager != null) {
                this.contextAuthenticationManager.register(this.context, this.authenticationProvider);
            }
        }
        if (this.versionResolverName != null) {
            this.versionResolver = (VersionResolver)this.directory.lookup(this.versionResolverName);
        }
        if (this.signerProviderName != null) {
            this.signerProvider = (ServerSignerProvider)this.directory.lookup(this.signerProviderName);
        }
        if (this.cookieName == null) {
            throw new IllegalStateException("CookieName not set");
        }
        String module = "com.ericsson.lwac.http.HttpOperationService";
        if (this.registry != null) {
            for (String key : this.registry.getKeys(module, DotStringPart.LAST)) {
                HttpOperationServiceListener listener = (HttpOperationServiceListener)this.registry.getValue(module, key);
                if (listener == null) continue;
                this.listeners.add(listener);
            }
        }
        if (this.registry != null) {
            for (String key : this.registry.getKeys(TOTPSetupProvider.class.getName(), DotStringPart.LAST)) {
                TOTPSetupProvider provider = (TOTPSetupProvider)this.registry.getValue(TOTPSetupProvider.class.getName(), key);
                if (provider == null) continue;
                this.totpSetupProviders.add(provider);
            }
        }
        this.sessionContextName = String.format("http-%s", this.context);
        this.communicationChannelManager.registerCommunicationChannel(CommunicationChannel.valueOf(this.sessionContextName));
        LinkedList<String> operationClassesCopy = new LinkedList<String>(this.operationClasses);
        operationClassesCopy.add(GetFeaturesOperation.class.getName());
        operationClassesCopy.add(GetPermissionsOperation.class.getName());
        operationClassesCopy.add(GetContextDetailsOperation.class.getName());
        this.httpOperationContainers.add(new HttpOperationContainerImpl(operationClassesCopy));
        LinkedList<OperationClassInfo> operationClassNameVersions = new LinkedList<OperationClassInfo>();
        for (HttpOperationContainer container : this.httpOperationContainers) {
            for (String operationClass : container.getOperationClasses()) {
                if (operationClass.equals(LogoutOperation.class.getName())) continue;
                Version version = Version.fromClassName(operationClass);
                Object installedObject = this.mainDeployer.install(operationClass);
                if (!(installedObject instanceof HttpOperationBase)) continue;
                logger.debug("Adding {} v{} to /{}", operationClass, version.toString(), this.context);
                HttpOperationBase httpOperation = (HttpOperationBase)installedObject;
                NameVersion nameVersion = new NameVersion(httpOperation.getName(), version);
                this.httpOperations.put(nameVersion, httpOperation);
                operationClassNameVersions.add(OperationClassInfo.of(operationClass, nameVersion));
            }
        }
        this.operationInfo = Collections.unmodifiableList(operationClassNameVersions);
        if (this.loginOperationClass != null) {
            this.loginOperation = (HttpAuthenticationManager)this.mainDeployer.install(this.loginOperationClass);
        }
        this.unexpectedErrorHandler = this.unexpectedErrorHandlerClass == null ? new DefaultUnexpectedErrorHandler() : (UnexpectedErrorHandler)this.mainDeployer.install(this.unexpectedErrorHandlerClass);
    }

    @Override
    public List<OperationClassInfo> getOperationClassInfo() {
        return Collections.unmodifiableList(this.operationInfo);
    }

    void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public void registerOperationContainer(HttpOperationContainer httpOperationContainer) {
        this.httpOperationContainers.add(httpOperationContainer);
    }

    @Override
    public void setAuthenticationProviderName(String authenticationProviderName) {
        this.authenticationProviderName = ObjectName.fromString(authenticationProviderName);
    }

    @Override
    public void onStop() {
    }

    @PostConstruct
    public void postConstruct() throws NamingException {
        if (this.directory == null) {
            this.directory = new InitialContext();
        }
        HttpConnectorService httpConnectorService = (HttpConnectorService)this.directory.lookup(this.httpConnectorName);
        this.registerProtocol(httpConnectorService);
        boolean bl = this.useQualifiedThreadNames = this.applicationProperties == null || Boolean.parseBoolean(this.applicationProperties.getProperty(HttpOperationProperty.HTTP_OPERATION_USE_QUALIFIED_THREAD_NAMES));
        if (this.applicationProperties != null && this.failedAuthenticationTime == 0L) {
            this.failedAuthenticationTime = Long.parseLong(this.applicationProperties.getProperty(HttpOperationProperty.HTTP_OPERATION_FAILED_AUTHENTICATION_TIME.getPropertyName(), HttpOperationProperty.HTTP_OPERATION_FAILED_AUTHENTICATION_TIME.getDefaultValue()));
        }
    }

    protected void registerProtocol(HttpConnectorService httpConnectorService) {
        httpConnectorService.registerProtocol(this);
    }

    @ServiceProperty
    public void setFailedAuthenticationTime(int val) {
        this.failedAuthenticationTime = val;
    }

    @Override
    public void setVersionResolverName(String resolverName) {
        this.versionResolverName = resolverName;
    }

    @Override
    public void setRequestInterceptorName(String requestInterceptorName) {
        logger.warn("{}: Trying to set request interceptor. This functionallity has been removed", (Object)this.context);
    }

    @Override
    public void setResponseInterceptorName(String responseInterceptorName) {
        logger.warn("{}: Trying to set response interceptor. This functionallity has been removed", (Object)this.context);
    }

    @Override
    public void registerHttpOperation(HttpOperation httpOperation) {
        NameVersion nameVersion = new NameVersion(httpOperation.getName(), Version.DEFAULT_VERSION);
        this.httpOperations.put(nameVersion, httpOperation);
    }

    public void setSignerProviderName(String signerProviderName) {
        this.signerProviderName = signerProviderName;
    }

    private static final class HttpOperationContainerImpl
    implements HttpOperationContainer {
        private final List<String> mOperationClasses;

        HttpOperationContainerImpl(List<String> operationClasses) {
            this.mOperationClasses = operationClasses;
        }

        @Override
        public List<String> getOperationClasses() {
            return this.mOperationClasses;
        }
    }

    public static class DefaultUnexpectedErrorHandler
    implements UnexpectedErrorHandler {
        @Override
        public void handle(RequestCorrelationId correlationId, String operation, Version version, OutputStream response, Exception e) {
            logger.warn(String.format("Unexpected exception in http service handler (%s:%s)", operation, version != null ? version : ""), e);
        }

        @Override
        public String getContentType() {
            return "text/plain";
        }
    }

    public static enum HttpOperationProperty implements ApplicationProperties.ApplicationProperty
    {
        HTTP_OPERATION_USE_QUALIFIED_THREAD_NAMES("http.operation.use_qualified_thread_names", "true"),
        HTTP_OPERATION_FAILED_AUTHENTICATION_TIME("http.operation.failed_authentication_time", "0");

        private final String propertyName;
        private final String defaultValue;

        private HttpOperationProperty(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

