/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.http.types.NameVersion;
import java.io.Serializable;

public class OperationClassInfo
implements Comparable<OperationClassInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String operationClassName;
    private final String name;
    private final String version;

    protected OperationClassInfo(String className, NameVersion nameVersion) {
        this.operationClassName = className;
        this.name = nameVersion.getName();
        this.version = nameVersion.getVersion().toString();
    }

    public String getOperationClassName() {
        return this.operationClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(OperationClassInfo o) {
        int res = this.name.compareTo(o.name);
        if (res == 0 && (res = this.version.compareTo(o.version)) == 0) {
            res = this.operationClassName.compareTo(o.operationClassName);
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.operationClassName == null ? 0 : this.operationClassName.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationClassInfo other = (OperationClassInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.operationClassName == null ? other.operationClassName != null : !this.operationClassName.equals(other.operationClassName)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return this.name + "/" + this.version + " [" + this.operationClassName + "]";
    }

    public static OperationClassInfo of(String operationClass, NameVersion nameVersion) {
        return new OperationClassInfo(operationClass, nameVersion);
    }
}

