/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli;

import com.ericsson.lwac.http.HttpOperation;
import com.ericsson.lwac.http.LogoutOperation;
import com.ericsson.lwac.http.cli.HttpSettingsFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class HttpDeprecatedOperationsScanner {
    private final File file;

    public HttpDeprecatedOperationsScanner(File file) {
        this.file = file;
    }

    public List<OperationClasses> getOperationClasses() {
        try {
            return HttpSettingsFileUtils.processXPathOn(this.file, "//*[@name='OperationClasses']").stream().map(OperationClasses::new).collect(Collectors.toList());
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getOperationService(OperationClasses opClasses) {
        Node node;
        try {
            node = HttpSettingsFileUtils.findSingleNode("../*[@name='OperationServices']/@value|../*[@name='Context']/@value", opClasses.element());
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return node.getNodeValue();
    }

    public List<Class<?>> getHttpOperations(OperationClasses opClasses) {
        LinkedList operations;
        try {
            List<Node> values = HttpSettingsFileUtils.findMultipleNodes("./p:property/@value", opClasses.element());
            operations = new LinkedList();
            for (Node value : values) {
                String val = value.getNodeValue();
                Class<?> clazz = this.getClass().getClassLoader().loadClass(val);
                if (!HttpOperation.class.isAssignableFrom(clazz) || LogoutOperation.class == clazz) continue;
                operations.add(clazz);
            }
        }
        catch (ClassNotFoundException | XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return operations;
    }

    public static boolean isDeprecated(Class<?> operationClass) {
        for (Method method : operationClass.getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!HttpDeprecatedOperationsScanner.isHandleMethod(method, parameterTypes) || !parameterTypes[0].isAnnotationPresent(Deprecated.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHandleMethod(Method method, Class<?>[] parameterTypes) {
        return HttpDeprecatedOperationsScanner.methodNameIsHandle(method) && (HttpDeprecatedOperationsScanner.singleParameterNotObject(parameterTypes) || HttpDeprecatedOperationsScanner.dualParametersSecondIsOutputStream(parameterTypes));
    }

    private static boolean methodNameIsHandle(Method method) {
        return method.getName().equals("handle");
    }

    private static boolean singleParameterNotObject(Class<?>[] parameterTypes) {
        return parameterTypes.length == 1 && parameterTypes[0] != Object.class;
    }

    private static boolean dualParametersSecondIsOutputStream(Class<?>[] parameterTypes) {
        return parameterTypes.length == 2 && parameterTypes[1] == OutputStream.class;
    }

    public static class OperationClasses {
        private final Element element;

        public OperationClasses(Element e) {
            this.element = e;
        }

        public Element element() {
            return this.element;
        }
    }
}

