/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli;

import com.ericsson.lwac.http.HttpOperationContainerBean;
import com.ericsson.lwac.http.HttpOperationServiceBean;
import com.ericsson.lwac.http.UnexpectedErrorHandler;
import com.ericsson.lwac.http.cli.HttpContextManagerBean;
import com.ericsson.lwac.http.cli.HttpSettingsFileUtils;
import com.ericsson.lwac.http.cli.domain.AuthProvider;
import com.ericsson.lwac.http.cli.domain.HttpService;
import com.ericsson.lwac.http.cli.domain.OperationClass;
import com.ericsson.lwac.http.cli.domain.OperationContainer;
import com.ericsson.lwac.http.cli.domain.ServiceFile;
import com.ericsson.lwac.kubernetes.KubernetesApiClient;
import com.ericsson.lwac.security.authentication.AuthenticationProvider;
import com.ericsson.lwac.settings.OverriddenServiceSettings;
import com.ericsson.lwac.settings.Property;
import com.ericsson.lwac.settings.ServiceSettings;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class HttpOperationHelper {
    private final File servicesDir;
    private final File templateDir;
    private final KubernetesApiClient apiClient;
    private final String applicationName;
    private final Predicate<File> activeFilter;
    private final Map<String, ServiceSettings> allServiceSettings;
    private final Map<String, OverriddenServiceSettings> allOverriddenServiceSettings;
    private final Map<String, Object> allServiceObjects;
    private static final FileFilter NON_HIDDEN_DIRECTORY_OR_XML_FILES = pathname -> !pathname.isHidden() && (pathname.isDirectory() || pathname.getName().endsWith(".xml"));
    public static final HttpContextManagerBean.ContextXmlTransformer STRIP_WHITESPACE = (output, source) -> {
        List<Node> emptyTextNodes;
        String whitespaceXPath = "//text()[string-length(normalize-space(.))=0]";
        try {
            emptyTextNodes = HttpSettingsFileUtils.findMultipleNodes(whitespaceXPath, source);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Unexpected error with xpath: " + whitespaceXPath, e);
        }
        for (Node node : emptyTextNodes) {
            node.getParentNode().removeChild(node);
        }
        return source;
    };

    private HttpOperationHelper(Builder builder) {
        File rootDir = builder.rootDir;
        this.apiClient = builder.apiClient;
        this.applicationName = builder.applicationName;
        this.activeFilter = builder.activeFilter;
        this.allServiceSettings = builder.allServiceSettings;
        this.allOverriddenServiceSettings = builder.allOverriddenServiceSettings;
        this.allServiceObjects = builder.allServiceObjects;
        this.servicesDir = new File(rootDir, "services");
        this.templateDir = new File(this.servicesDir, "templates");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String createAll(boolean force) throws IOException {
        File[] sources = this.templateDir.listFiles(NON_HIDDEN_DIRECTORY_OR_XML_FILES);
        StringBuilder output = new StringBuilder();
        if (sources == null) {
            output.append(String.format("Template file %s not found, skipping.", this.templateDir));
            return output.toString();
        }
        this.apiClient.updateConfigMap(this.applicationName + "-services", destinationDirectory -> {
            for (File source : sources) {
                Path src = source.toPath();
                String context = source.getName();
                String comment = "CreateAll done at " + String.valueOf(DateTime.now());
                HttpContextManagerBean.ContextXmlTransformer transformer = this.createTransformer(context, null, null, null, comment);
                this.copyFileOrFolder(output, src, (Path)destinationDirectory, force, transformer);
            }
            return true;
        });
        return output.toString();
    }

    public String create(String templateName, String context, String authenticationProvider, String errorHandler, String comment, boolean onlyTemplates, boolean force) throws IOException, XPathExpressionException, ParserConfigurationException, ClassNotFoundException, SAXException {
        StringBuilder output = new StringBuilder();
        File source = new File(this.templateDir, templateName);
        if (errorHandler != null) {
            this.validateErrorHandler(errorHandler);
        }
        if (authenticationProvider != null) {
            this.validateAuthenticationProvider(source, authenticationProvider, onlyTemplates);
        }
        HttpContextManagerBean.ContextXmlTransformer transformer = this.createTransformer(context, context, authenticationProvider, errorHandler, comment);
        this.apiClient.updateConfigMap(this.applicationName + "-services", destinationDirectory -> {
            if (source.isDirectory()) {
                this.copyFolder(output, source.toPath(), (Path)destinationDirectory, force, transformer);
            } else {
                this.copyFile(output, source.toPath(), destinationDirectory.resolve(source.getName().replace(".xml", String.format("-%s.xml", context))), force, transformer);
            }
            return true;
        });
        return output.toString();
    }

    public List<ServiceFile> getContextServiceFiles(boolean isListProperties, @Nullable String inputContext) throws IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        List<File> xmlFiles = HttpSettingsFileUtils.getXmlFiles(new File(this.servicesDir, "external"), false, true);
        LinkedList<ServiceFile> serviceFiles = new LinkedList<ServiceFile>();
        LinkedHashMap<String, HttpService> httpServices = new LinkedHashMap<String, HttpService>();
        LinkedHashMap<String, OperationContainer> operationContainers = new LinkedHashMap<String, OperationContainer>();
        LinkedHashMap<String, AuthProvider> authProviders = new LinkedHashMap<String, AuthProvider>();
        for (File xmlFile : xmlFiles) {
            List<Element> serviceList = HttpSettingsFileUtils.processXPathOn(xmlFile, "s:services/s:service");
            block5: for (Element serviceElement : serviceList) {
                String serviceName = serviceElement.getAttribute("name");
                ServiceSettings serviceSettings = this.allServiceSettings.get(serviceName);
                if (serviceSettings == null) {
                    this.handleDisabledService(serviceFiles, authProviders, xmlFile, serviceElement, inputContext);
                    continue;
                }
                OverriddenServiceSettings overriddenServiceSettings = this.allOverriddenServiceSettings.get(serviceName);
                ServiceType serviceType = ServiceType.valueOfBeanName(serviceSettings.getBeanClass());
                switch (serviceType.ordinal()) {
                    case 0: {
                        if (!this.matchInputContext(serviceElement, inputContext)) break;
                        HttpService httpService = this.createHttpService(authProviders, serviceSettings, overriddenServiceSettings, inputContext);
                        this.addMatchingOperationContainersToService(httpService, operationContainers, isListProperties);
                        httpServices.put(httpService.getName(), httpService);
                        this.addOrUpdateToServiceFile(serviceFiles, httpService, xmlFile);
                        break;
                    }
                    case 1: {
                        OperationContainer operationContainer = this.collectOperationContainerDetail(serviceSettings, overriddenServiceSettings, xmlFile, isListProperties, inputContext);
                        if (operationContainer == null) continue block5;
                        this.updateContainerInHttpServices(httpServices, operationContainer);
                        operationContainers.put(operationContainer.getName(), operationContainer);
                        break;
                    }
                    default: {
                        Object serviceObject = this.allServiceObjects.get(serviceName);
                        if (!AuthenticationProvider.class.isAssignableFrom(serviceObject.getClass())) continue block5;
                        this.handleAuthProvider(httpServices, authProviders, serviceSettings, isListProperties);
                    }
                }
            }
        }
        return serviceFiles;
    }

    private void handleDisabledService(List<ServiceFile> serviceFiles, Map<String, AuthProvider> authProviders, File xmlFile, Element serviceElement, @Nullable String inputContext) throws XPathExpressionException {
        String beanClass = serviceElement.getAttribute("bean-class");
        ServiceType serviceType = ServiceType.valueOfBeanName(beanClass);
        if (serviceType != ServiceType.HTTP_OPERATION_SERVICE) {
            return;
        }
        List<Element> serviceProperties = HttpSettingsFileUtils.findMultipleElements("p:properties/p:property", serviceElement);
        Map<String, String> properties = serviceProperties.stream().collect(Collectors.toMap(propEle -> propEle.getAttribute("name"), propEle -> propEle.getAttribute("value")));
        if (inputContext != null && !inputContext.equals(properties.get("Context"))) {
            return;
        }
        String authProviderName = properties.get("AuthenticationProviderName");
        AuthProvider authProvider = authProviders.computeIfAbsent(authProviderName, k -> AuthProvider.newBuilder().name(authProviderName).properties(new TreeMap<String, String>(this.getServiceSettingsProperties(this.allServiceSettings.get(authProviderName)))).build());
        HttpService httpService = HttpService.newBuilder().name(serviceElement.getAttribute("name")).beanClass(beanClass).context(properties.get("Context")).authProvider(authProvider).enabled(false).build();
        this.addOrUpdateToServiceFile(serviceFiles, httpService, xmlFile);
    }

    private void updateContainerInHttpServices(Map<String, HttpService> httpServices, OperationContainer operationContainer) {
        for (String httpServiceName : operationContainer.getOperationServices()) {
            if (!httpServices.containsKey(httpServiceName)) continue;
            List<OperationContainer> savedOpContainers = httpServices.get(httpServiceName).getOperationContainers();
            if (savedOpContainers.contains(operationContainer)) {
                savedOpContainers.replaceAll(opCtr -> opCtr.getName().equals(operationContainer.getName()) ? operationContainer : opCtr);
                continue;
            }
            savedOpContainers.add(operationContainer);
        }
    }

    private void addOrUpdateToServiceFile(List<ServiceFile> serviceFiles, HttpService httpService, File xmlFile) {
        Optional<ServiceFile> serviceFile = serviceFiles.stream().filter(svcFile -> svcFile.getPath().equals(xmlFile.getName())).findFirst();
        serviceFile.ifPresentOrElse(file -> file.getHttpServices().replaceAll(httpSvc -> httpSvc.getName().equals(httpService.getName()) ? httpService : httpSvc), () -> serviceFiles.add(ServiceFile.newBuilder().path(xmlFile.getName()).addHttpService(httpService).build()));
    }

    private boolean matchInputContext(Element element, @Nullable String inputContext) throws XPathExpressionException {
        if (inputContext == null) {
            return true;
        }
        Element contextProperty = HttpSettingsFileUtils.findElement("p:properties/p:property[@name='Context']", element);
        return contextProperty != null && inputContext.equals(contextProperty.getAttribute("value"));
    }

    private OperationContainer collectOperationContainerDetail(ServiceSettings serviceSettings, OverriddenServiceSettings overriddenServiceSettings, File xmlFile, boolean isListProperties, @Nullable String inputContext) {
        if (!isListProperties) {
            return null;
        }
        Map<String, String> mergedProperties = this.getMergedSettingsProperties(serviceSettings, overriddenServiceSettings);
        if (inputContext != null && !this.matchHttpServiceContext(mergedProperties, inputContext)) {
            return null;
        }
        return this.createOperationContainer(serviceSettings, xmlFile, mergedProperties, inputContext);
    }

    private boolean matchHttpServiceContext(Map<String, String> settingsProperties, String inputContext) {
        List operationServices = Arrays.stream(settingsProperties.get("OperationServices").split(",")).map(String::trim).collect(Collectors.toList());
        return operationServices.stream().anyMatch(svc -> inputContext.equals(this.getMergedSettingsProperties(this.allServiceSettings.get(svc), this.allOverriddenServiceSettings.get(svc)).get("Context")));
    }

    private void handleAuthProvider(Map<String, HttpService> httpServices, Map<String, AuthProvider> authProviders, ServiceSettings serviceSettings, boolean isListProperties) {
        Optional<AuthProvider> authProvider = httpServices.values().stream().map(HttpService::getAuthProvider).filter(provider -> serviceSettings.getName().getName().equals(provider.getName())).findFirst();
        if (isListProperties) {
            Map<String, String> settingsProperties = this.getServiceSettingsProperties(serviceSettings);
            authProvider.ifPresentOrElse(authProv -> authProv.getProperties().putAll(settingsProperties), () -> authProviders.put(serviceSettings.getName().getName(), this.createAuthProvider(serviceSettings.getName().getName(), settingsProperties)));
        }
    }

    private void addMatchingOperationContainersToService(HttpService httpService, Map<String, OperationContainer> operationContainers, boolean isListProperties) {
        if (isListProperties) {
            List matchingOpContainers = operationContainers.values().stream().filter(opContainer -> opContainer.getOperationServices().contains(httpService.getName())).collect(Collectors.toList());
            httpService.getOperationContainers().addAll(matchingOpContainers);
        }
    }

    private HttpService createHttpService(Map<String, AuthProvider> authProviders, ServiceSettings serviceSettings, OverriddenServiceSettings overriddenServiceSettings, @Nullable String inputContext) {
        Map<String, String> properties = this.getMergedSettingsProperties(serviceSettings, overriddenServiceSettings);
        String authProviderName = properties.get("AuthenticationProviderName");
        AuthProvider authProvider = authProviders.computeIfAbsent(authProviderName, k -> this.createAuthProvider(authProviderName, this.getMergedSettingsProperties(this.allServiceSettings.get(authProviderName), this.allOverriddenServiceSettings.get(authProviderName))));
        HttpService.Builder serviceBuilder = HttpService.newBuilder().name(serviceSettings.getName().getName()).beanClass(serviceSettings.getBeanClass()).context(properties.get("Context")).errHandler(properties.get("UnexpectedErrorHandlerClass")).authProvider(authProvider);
        if (inputContext != null && properties.containsKey("OperationClasses")) {
            List<OperationClass> operationClasses = this.getOperationClasses(properties);
            serviceBuilder.operationClasses(operationClasses);
        }
        return serviceBuilder.build();
    }

    private OperationContainer createOperationContainer(ServiceSettings serviceSettings, File xmlFile, Map<String, String> settingsProperties, @Nullable String inputContext) {
        OperationContainer.Builder opContainerBuilder = OperationContainer.newBuilder().name(serviceSettings.getName().getName()).path(xmlFile.getName()).operationServices(Arrays.stream(settingsProperties.get("OperationServices").split(",")).map(String::trim).collect(Collectors.toList()));
        if (inputContext != null && settingsProperties.containsKey("OperationClasses")) {
            List<OperationClass> operationClasses = this.getOperationClasses(settingsProperties);
            opContainerBuilder.operationClasses(operationClasses);
        }
        return opContainerBuilder.build();
    }

    private List<OperationClass> getOperationClasses(Map<String, String> properties) {
        String opClasses = properties.get("OperationClasses").replace("[", "").replace("]", "");
        return Arrays.stream(opClasses.split(",")).map(name -> OperationClass.newBuilder().name(name.trim()).shortName(name.trim().replaceAll("(\\B[a-z]+)(\\.[a-z](?=\\B[a-z_\\d]+.[a-z]))", "$2")).build()).collect(Collectors.toList());
    }

    private AuthProvider createAuthProvider(String name, Map<String, String> properties) {
        return AuthProvider.newBuilder().name(name).properties(new TreeMap<String, String>(properties)).build();
    }

    private Map<String, String> getMergedSettingsProperties(@Nullable ServiceSettings serviceSettings, @Nullable OverriddenServiceSettings overriddenServiceSettings) {
        TreeMap<String, String> defaultProperties = new TreeMap<String, String>(this.getServiceSettingsProperties(serviceSettings));
        if (overriddenServiceSettings != null) {
            overriddenServiceSettings.getProperties().forEach(override -> defaultProperties.put(override.getName(), override.valueToString()));
        }
        return defaultProperties;
    }

    private Map<String, String> getServiceSettingsProperties(@Nullable ServiceSettings serviceSettings) {
        if (serviceSettings == null) {
            return Collections.emptyMap();
        }
        return serviceSettings.getProperties().stream().collect(Collectors.toMap(Property::getName, Property::valueToString));
    }

    private void validateAuthenticationProvider(File templateDirOrFile, String authenticationProvider, boolean onlyTemplates) throws XPathExpressionException, IOException, ParserConfigurationException, ClassNotFoundException, SAXException {
        List<FileAndService> authProviderServices = this.getAllServicesOfClassFromRootDir(this.servicesDir, onlyTemplates);
        List<FileAndService> fromTemplates = this.getAllServicesOfClassFromRootDir(templateDirOrFile, onlyTemplates);
        authProviderServices.addAll(fromTemplates);
        if (authProviderServices.stream().noneMatch(s -> authenticationProvider.equals(s.serviceElement.getAttribute("name")))) {
            throw new IllegalArgumentException("Authentication provider service not found: " + authenticationProvider);
        }
    }

    private void validateErrorHandler(String errorHandler) {
        boolean accepted = false;
        try {
            Class<?> errorHandlerClass = ClassLoader.getSystemClassLoader().loadClass(errorHandler);
            if (UnexpectedErrorHandler.class.isAssignableFrom(errorHandlerClass)) {
                accepted = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!accepted) {
            throw new IllegalArgumentException("Class is not an UnexpectedErrorHandler: " + errorHandler);
        }
    }

    private void copyFileOrFolder(StringBuilder output, Path src, Path dst, boolean force, HttpContextManagerBean.ContextXmlTransformer transformer) throws IOException {
        if (Files.isSymbolicLink(src)) {
            output.append(String.format("Source file %s is a symbolic link, will not be copied%n", src));
        } else if (Files.isSymbolicLink(dst)) {
            output.append(String.format("Destination file %s is a symbolic link, will not be copied to%n", dst));
        } else if (Files.isDirectory(src, LinkOption.NOFOLLOW_LINKS)) {
            if (Files.exists(dst, LinkOption.NOFOLLOW_LINKS) && !Files.isDirectory(dst, LinkOption.NOFOLLOW_LINKS)) {
                output.append(String.format("Destination file %s exists, but is not a directory, aborting%n", dst));
                throw new IOException("Existing non-directory destination: " + String.valueOf(dst));
            }
            this.copyFolder(output, src, dst, force, transformer);
        } else {
            this.copyFile(output, src, dst, force, transformer);
        }
    }

    private void copyFolder(StringBuilder output, Path src, Path dst, boolean force, HttpContextManagerBean.ContextXmlTransformer transformer) throws IOException {
        if (!Files.exists(dst, LinkOption.NOFOLLOW_LINKS) && !dst.toFile().mkdirs()) {
            output.append(String.format("Failed creating directory %s%n", dst));
            throw new IOException("Failed creating directory " + String.valueOf(dst));
        }
        File[] files = src.toFile().listFiles(NON_HIDDEN_DIRECTORY_OR_XML_FILES);
        if (files == null) {
            output.append(String.format("Failed reading contents of directory %s%n", src));
            throw new IOException("Failed reading contents of directory " + String.valueOf(src));
        }
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList);
        for (File file : fileList) {
            File target = new File(dst.toFile(), file.getName());
            this.copyFileOrFolder(output, file.toPath(), target.toPath(), force, transformer);
        }
    }

    private void copyFile(StringBuilder output, Path src, Path dst, boolean force, HttpContextManagerBean.ContextXmlTransformer transformer) throws IOException {
        boolean notExists = Files.notExists(dst, new LinkOption[0]);
        Path svcRoot = this.servicesDir.toPath();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(src.toFile()));){
            File destination = dst.toFile();
            if (notExists) {
                output.append(String.format("Creating %s from %s%n", dst.getFileName(), svcRoot.relativize(src)));
                this.transformStreamToFile(output, in, destination, transformer);
            } else {
                output.append(String.format("Target file %s already exists, ", dst.getFileName()));
                if (force) {
                    output.append(String.format("overwriting with %s%n", svcRoot.relativize(src)));
                    this.transformStreamToFile(output, in, destination, transformer);
                } else {
                    output.append("skipping\n");
                }
            }
        }
        catch (ParserConfigurationException | TransformerException | XPathExpressionException | SAXException x) {
            throw new IOException("Failed copying " + String.valueOf(src) + " to " + String.valueOf(dst), x);
        }
    }

    private void transformStreamToFile(StringBuilder output, InputStream in, File dest, HttpContextManagerBean.ContextXmlTransformer transformer) throws IOException, XPathExpressionException, TransformerException, ParserConfigurationException, SAXException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Document result = transformer.transform(output, document);
            Transformer transformer1 = TransformerFactory.newInstance().newTransformer();
            transformer1.setOutputProperty("method", "xml");
            transformer1.setOutputProperty("indent", "yes");
            transformer1.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer1.transform(new DOMSource(result), new StreamResult(out));
        }
    }

    private List<FileAndService> getServicesOfClassFromFile(File xmlFile, ClassLoader classLoader) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, ClassNotFoundException {
        List<Element> list = HttpSettingsFileUtils.processXPathOn(xmlFile, "s:services/s:service");
        LinkedList<FileAndService> result = new LinkedList<FileAndService>();
        for (Element element : list) {
            String beanClass = element.getAttribute("bean-class");
            Class<?> clazz = classLoader.loadClass(beanClass);
            if (!AuthenticationProvider.class.isAssignableFrom(clazz)) continue;
            result.add(new FileAndService(xmlFile, element));
        }
        return result;
    }

    private List<FileAndService> getAllServicesOfClassFromRootDir(File dir, boolean onlyTemplates) throws IOException, XPathExpressionException, ClassNotFoundException, ParserConfigurationException, SAXException {
        List<File> xmlFiles = this.getXmlFiles(dir, onlyTemplates);
        LinkedList<FileAndService> result = new LinkedList<FileAndService>();
        for (File file : xmlFiles) {
            List<FileAndService> list = this.getServicesOfClassFromFile(file, ClassLoader.getSystemClassLoader());
            result.addAll(list);
        }
        return result;
    }

    private HttpContextManagerBean.ContextXmlTransformer createTransformer(final String suffix, final String context, final String authenticationProvider, final String errorHandler, final String comment) {
        return new HttpContextManagerBean.ContextXmlTransformer(){

            @Override
            public Document transform(StringBuilder output, Document rootElem) throws XPathExpressionException {
                Document root = STRIP_WHITESPACE.transform(output, rootElem);
                Element operationService = HttpSettingsFileUtils.findElement("s:services/s:service[contains(@bean-class, 'HttpOperationServiceBean')]", root);
                if (operationService != null) {
                    Element authProviderProperty;
                    this.updateServiceName(operationService);
                    this.updateComment(operationService);
                    if (context != null) {
                        Element contextProperty = HttpSettingsFileUtils.findElement("p:properties/p:property[@name='Context']", operationService);
                        contextProperty.setAttribute("value", context);
                    }
                    if (authenticationProvider != null) {
                        authProviderProperty = HttpSettingsFileUtils.findElement("p:properties/p:property[@name='AuthenticationProviderName']", operationService);
                        authProviderProperty.setAttribute("value", authenticationProvider);
                    }
                    if (errorHandler != null) {
                        authProviderProperty = HttpSettingsFileUtils.findElement("p:properties/p:property[@name='UnexpectedErrorHandlerClass']", operationService);
                        authProviderProperty.setAttribute("value", errorHandler);
                    }
                }
                List<Element> containers = HttpSettingsFileUtils.findMultipleElements("s:services/s:service[@bean-class='com.ericsson.lwac.http.HttpOperationContainerBean']", root);
                for (Element container : containers) {
                    this.updateServiceName(container);
                    Element operationServicesProperty = HttpSettingsFileUtils.findElement("p:properties/p:property[@name='OperationServices']", container);
                    String serviceName = operationServicesProperty.getAttribute("value");
                    if (serviceName.contains("-")) {
                        output.append(String.format("Not updating service name %s as it already contains -%n", serviceName));
                        continue;
                    }
                    operationServicesProperty.setAttribute("value", serviceName + "-" + suffix);
                }
                return root;
            }

            private void updateServiceName(Element service) {
                String serviceName = service.getAttribute("name");
                service.setAttribute("name", serviceName + "-" + suffix);
            }

            private void updateComment(Element service) throws XPathExpressionException {
                Element commentElement = HttpSettingsFileUtils.findElement("s:comment", service);
                if (commentElement == null) {
                    commentElement = service.getOwnerDocument().createElementNS("http://www.ericsson.com/lwac/services", "comment");
                    service.insertBefore(commentElement, service.getFirstChild());
                }
                commentElement.setTextContent(comment);
            }
        };
    }

    private List<File> getXmlFiles(File rootDir, boolean onlyTemplates) throws IOException {
        return HttpSettingsFileUtils.getXmlFiles(rootDir, onlyTemplates);
    }

    public static final class Builder {
        private KubernetesApiClient apiClient;
        private String applicationName;
        private File rootDir;
        private Predicate<File> activeFilter = f -> true;
        private Map<String, ServiceSettings> allServiceSettings;
        private Map<String, OverriddenServiceSettings> allOverriddenServiceSettings;
        private Map<String, Object> allServiceObjects;

        private Builder() {
        }

        public Builder apiClient(KubernetesApiClient val) {
            this.apiClient = val;
            return this;
        }

        public Builder applicationName(String val) {
            this.applicationName = val;
            return this;
        }

        public Builder activeFilter(Predicate<File> val) {
            this.activeFilter = val;
            return this;
        }

        public Builder allServiceSettings(Map<String, ServiceSettings> allServiceSettings) {
            this.allServiceSettings = allServiceSettings;
            return this;
        }

        public Builder allOverriddenServiceSettings(Map<String, OverriddenServiceSettings> allOverriddenServiceSettings) {
            this.allOverriddenServiceSettings = allOverriddenServiceSettings;
            return this;
        }

        public Builder allServiceObjects(Map<String, Object> allServiceObjects) {
            this.allServiceObjects = allServiceObjects;
            return this;
        }

        public HttpOperationHelper build() {
            return new HttpOperationHelper(this);
        }

        public Builder rootDir(File val) {
            this.rootDir = val;
            return this;
        }
    }

    private static enum ServiceType {
        HTTP_OPERATION_SERVICE(HttpOperationServiceBean.class.getCanonicalName()),
        HTTP_OPERATION_CONTAINER(HttpOperationContainerBean.class.getCanonicalName()),
        UNKNOWN("Unknown");

        private final String beanName;

        private ServiceType(String beanName) {
            this.beanName = beanName;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public static ServiceType valueOfBeanName(String beanName) {
            for (ServiceType svcType : ServiceType.values()) {
                if (!svcType.getBeanName().equals(beanName)) continue;
                return svcType;
            }
            return UNKNOWN;
        }
    }

    private static final class FileAndService
    implements Comparable<FileAndService> {
        final File file;
        final String name;
        final Element serviceElement;

        public FileAndService(File file, Element element) {
            this.file = file;
            this.serviceElement = element;
            this.name = this.serviceElement.getAttribute("name");
        }

        @Override
        public int compareTo(FileAndService o) {
            int result = this.file.compareTo(o.file);
            if (result == 0) {
                return this.name.compareTo(o.name);
            }
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileAndService other = (FileAndService)obj;
            if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
                return false;
            }
            if (this.name == null) {
                return other.name == null;
            }
            return this.name.equals(other.name);
        }
    }
}

