/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.cli.InContainerCLIEnvironment;
import com.ericsson.lwac.cli.commands.Command;
import com.ericsson.lwac.cli.commands.InContainerAction;
import com.ericsson.lwac.http.cli.HttpOperationHelper;
import java.io.IOException;

@Command(name="context")
@Parameters(separators="=")
public class InternalHttpContextCommand {

    @Command(name="create-all")
    @Parameters(separators="=")
    private static final class CreateAllCommand
    implements InContainerAction {
        @Parameter(description="overwrite original files, if present", names={"-f", "--force"})
        private boolean force;

        private CreateAllCommand() {
        }

        @Override
        public void execute(InContainerCLIEnvironment environment) throws ExecutionException {
            try {
                HttpOperationHelper helper = HttpOperationHelper.newBuilder().apiClient(environment.getKubernetesApiClient()).applicationName(environment.getApplicationName()).rootDir(environment.getApplicationDirectory()).build();
                environment.getOutputWriter().println(helper.createAll(this.force));
            }
            catch (IOException e) {
                throw new ExecutionException("Could not create contexts", e);
            }
        }
    }
}

