/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli.domain;

import com.ericsson.lwac.http.cli.domain.OperationClass;
import java.io.Serializable;
import java.util.List;

public class OperationContainer
implements Serializable {
    private final String name;
    private final String path;
    private final List<OperationClass> operationClasses;
    private final List<String> operationServices;

    public OperationContainer(Builder builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.operationClasses = builder.operationClasses;
        this.operationServices = builder.operationServices;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<OperationClass> getOperationClasses() {
        return this.operationClasses;
    }

    public List<String> getOperationServices() {
        return this.operationServices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationContainer that = (OperationContainer)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String path;
        private List<OperationClass> operationClasses;
        private List<String> operationServices;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder operationClasses(List<OperationClass> operationClasses) {
            this.operationClasses = operationClasses;
            return this;
        }

        public Builder operationServices(List<String> operationServices) {
            this.operationServices = operationServices;
            return this;
        }

        public OperationContainer build() {
            return new OperationContainer(this);
        }
    }
}

