/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.trace;

import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.http.BufferedOutputStream;
import com.ericsson.lwac.http.CallContext;
import com.ericsson.lwac.http.HttpOperationCallContext;
import com.ericsson.lwac.http.trace.HttpTraceData;
import com.ericsson.lwac.http.trace.HttpTraceService;
import com.ericsson.lwac.net.http.BufferedHttpServletRequest;
import com.ericsson.lwac.net.http.trace.HttpRequestTraceRecord;
import com.ericsson.lwac.net.http.trace.HttpResponseTraceRecord;
import com.ericsson.lwac.net.http.trace.HttpTraceLoggerService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import jakarta.annotation.Resource;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;

@Service
public class HttpTraceServiceBean
implements HttpTraceService {
    @Resource
    private HttpTraceLoggerService httpTraceLogger;
    private static final Charset charset = StandardCharsets.UTF_8;
    private static final ThreadLocal<HttpTraceData> traceData = ThreadLocal.withInitial(HttpTraceData::new);
    public static final List<String> secrets = Collections.unmodifiableList(Arrays.asList("<secret>.*</secret>", "<newsecret>.*</newsecret>", "<oldsecret>.*</oldsecret>", "<repeatedsecret>.*</repeatedsecret>", "<cvv>.*</cvv>", "<cardnumber>.*</cardnumber>", "<cardverificationvalue>.*</cardverificationvalue>", "<securityquestionanswer>.*</securityquestionanswer>", "<answer>.*</answer>", "<password>.*</password>", "<otp>.*</otp>", "<token>.*</token>", "<securityanswer>.*</securityanswer>", "<answertosecurityquestion>.*</answertosecurityquestion>", "<newpassword>.*</newpassword>", "<pin>.*</pin>", "<oldpin>.*</oldpin>", "<linkverificationcode>.*</linkverificationcode>", "<cardexpiry>.*</cardexpiry>"));

    @Override
    public void setStartTime() {
        if (this.httpTraceLogger.isListening()) {
            this.reset();
            traceData.get().setUniqueId(UUID.randomUUID());
            traceData.get().setStartTime(DateTime.now().getMillis());
        }
    }

    @Override
    public void setStatus(int code) {
        traceData.get().setStatus(code);
    }

    @Override
    public void setRedirectLocation(String url) {
        traceData.get().setRedirectLocation(url);
    }

    @Override
    public void setSession(long aSessionId) {
        traceData.get().setSessionId(aSessionId);
    }

    @Override
    public void logRequest(HttpOperationCallContext context) {
        if (this.httpTraceLogger.isListening() && traceData.get().getUniqueId() != null && context instanceof CallContext) {
            BufferedHttpServletRequest bufferingWrapper = ((CallContext)context).getRequestWrapper();
            int size = 0;
            List<ByteBuffer> buffers = bufferingWrapper.getRequestBuffers();
            for (ByteBuffer b : buffers) {
                size += b.limit();
            }
            ByteBuffer body = ByteBuffer.allocate(size);
            buffers.forEach(body::put);
            ((Buffer)body).flip();
            HttpRequestTraceRecord traceRecord = HttpRequestTraceRecord.builder().uniqueId(traceData.get().getUniqueId()).sessionId(traceData.get().getSessionId()).loggingTimeEpochMilliseconds(traceData.get().getStartTime()).requestUri(context.getRealRequest().getRequestURI()).remotePort(context.getRealRequest().getRemotePort()).requestBody(this.removeSecrets(new String(body.array(), charset).trim())).build();
            this.httpTraceLogger.logRequest(traceRecord);
        }
    }

    @Override
    public void logResponse(HttpOperationCallContext context) {
        if (this.httpTraceLogger.isListening() && traceData.get().getUniqueId() != null && context instanceof CallContext) {
            BufferedOutputStream bufferedOutputStream = ((CallContext)context).getResponseOutputStream();
            String response = "";
            if (bufferedOutputStream.getBufferList().size() != 0) {
                for (ByteBuffer buf : bufferedOutputStream.getBufferList()) {
                    response = response.concat(this.removeSecrets(new String(buf.array(), charset).trim()));
                }
            }
            HttpResponseTraceRecord traceRecord = HttpResponseTraceRecord.builder().uniqueId(traceData.get().getUniqueId()).sessionId(traceData.get().getSessionId()).loggingTimeEpochMilliseconds(DateTime.now().getMillis()).responseBody(Strings.emptyToNull(response)).responseStatus(traceData.get().getStatus()).build();
            this.httpTraceLogger.logResponse(traceRecord);
        }
    }

    private String removeSecrets(String data) {
        String text = data;
        for (String element : secrets) {
            text = text.replaceAll(element, element.replace(".*", "******"));
        }
        return text;
    }

    @VisibleForTesting
    void reset() {
        traceData.get().reset();
    }
}

