/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.ws;

import com.ericsson.lwac.http.BufferedOutputStream;
import com.ericsson.lwac.http.HttpOperationCallContext;
import com.ericsson.lwac.net.http.core.HttpHeader;
import com.ericsson.lwac.net.http.core.HttpResponseCode;
import com.ericsson.lwac.net.ws.server.WebSocketUpgradeRequest;
import com.ericsson.lwac.net.ws.server.WebSocketUpgradeResponse;
import com.google.common.net.MediaType;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;

public class WebSocketUpgradeCallContext
implements HttpOperationCallContext {
    private final WebSocketUpgradeRequest webSocketUpgradeRequest;
    private final WebSocketUpgradeResponse webSocketUpgradeResponse;
    private BufferedOutputStream responseOutputStream = new BufferedOutputStream();
    private HttpResponseCode responseCode = HttpResponseCode.OK;
    private String sessionId = null;
    private boolean singleCallLogin = false;
    private boolean failure = true;
    private MediaType responseContentType = null;

    public WebSocketUpgradeCallContext(WebSocketUpgradeRequest webSocketUpgradeRequest, WebSocketUpgradeResponse webSocketUpgradeResponse) {
        this.webSocketUpgradeRequest = webSocketUpgradeRequest;
        this.webSocketUpgradeResponse = webSocketUpgradeResponse;
    }

    @Override
    public HttpServletRequest getRealRequest() {
        return this.webSocketUpgradeRequest.getAsServletRequest();
    }

    @Override
    public void finishResponse() throws IOException {
        if (this.responseCode.isError()) {
            List<ByteBuffer> buffers = this.getResponseOutputStream().getBufferList();
            Charset charset = Optional.ofNullable(this.responseContentType).map(MediaType::charset).filter(com.google.common.base.Optional::isPresent).map(com.google.common.base.Optional::get).orElse(StandardCharsets.UTF_8);
            StringBuilder errorMessage = new StringBuilder(64);
            for (ByteBuffer buffer : buffers) {
                errorMessage.append(charset.decode(buffer));
            }
            this.webSocketUpgradeResponse.setErrorResponse(this.responseCode, errorMessage.toString());
        }
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(String value) {
        this.sessionId = value;
    }

    @Override
    public BufferedOutputStream getResponseOutputStream() throws IOException {
        return this.responseOutputStream;
    }

    @Override
    public void setResponseOutputStream(BufferedOutputStream responseOutputStream) throws IOException {
        this.responseOutputStream = responseOutputStream;
    }

    @Override
    public boolean isSingleCallLogin() {
        return this.singleCallLogin;
    }

    @Override
    public void setSingleCallLogin(boolean singleCallLogin) {
        this.singleCallLogin = singleCallLogin;
    }

    @Override
    public boolean isFailure() {
        return this.failure;
    }

    @Override
    public void setFailure(boolean failure) {
        this.failure = failure;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.webSocketUpgradeRequest.getAsServletRequest();
    }

    @Override
    public void markResponseFinished() {
        this.responseOutputStream.flipBuffers();
    }

    @Override
    public void setResponseHeader(String name, String value) {
        this.webSocketUpgradeResponse.addHeader(HttpHeader.fromNameAndValue(name, value));
    }

    @Override
    public void setContentType(String mediaType) {
        this.responseContentType = MediaType.parse(mediaType);
        this.webSocketUpgradeResponse.addHeader(HttpHeader.fromNameAndValue("Content-Type", mediaType));
    }

    @Override
    public void setStatus(int statusCode) {
        this.responseCode = HttpResponseCode.fromInt(statusCode);
    }

    @Override
    public void addCookie(Cookie cookie) {
    }

    @Override
    public void closeOutputStream() throws IOException {
        this.responseOutputStream.close();
    }

    @Override
    public void sendRedirect(String redirectUrl) throws IOException {
        throw new UnsupportedOperationException("Unable to redirect WebSocket upgrade requests");
    }
}

