/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.ws.xml;

import com.ericsson.lwac.http.ByteBuffersInputStream;
import com.ericsson.lwac.http.ws.WebSocketOperationSessionData;
import com.ericsson.lwac.http.ws.xml.XmlWebSocketOperation;
import com.ericsson.lwac.http.xml.JAXBContextRepository;
import com.ericsson.lwac.net.ws.exchange.WebSocketMessage;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class AbstractXmlWebSocketOperation<T extends WebSocketOperationSessionData, Mi, Mo>
implements XmlWebSocketOperation<T, Mi, Mo> {
    private final Class<Mi> classOfInputMessage;
    private final Class<Mo> classOfOutputMessage;

    protected AbstractXmlWebSocketOperation() {
        JAXBContextRepository.registerContext(this.getClass(), this.getInputMessageClass(), this.getOutputMessageClass());
        this.classOfInputMessage = this.getInputMessageClass();
        this.classOfOutputMessage = this.getOutputMessageClass();
    }

    @Override
    public Mi unmarshal(WebSocketMessage message) throws JAXBException, IOException {
        Unmarshaller unm = JAXBContextRepository.createUnmarshallerFor(this.getClass());
        try (ByteBuffersInputStream inputStream = new ByteBuffersInputStream(List.of(message.getByteBuffer()));){
            Mi Mi = this.classOfInputMessage.cast(unm.unmarshal(JAXBContextRepository.createXmlSource(inputStream)));
            return Mi;
        }
    }

    @Override
    public WebSocketMessage marshal(Mo message) throws JAXBException {
        Marshaller marshaller = JAXBContextRepository.createMarshallerFor(this.getClass());
        marshaller.setProperty("jaxb.encoding", "UTF-8");
        StringWriter xml = new StringWriter();
        marshaller.marshal(message, xml);
        ByteBuffer byteBuffer = ByteBuffer.wrap(xml.toString().getBytes(StandardCharsets.UTF_8));
        return WebSocketMessage.fromByteBuffer(byteBuffer);
    }

    protected abstract Class<Mi> getInputMessageClass();

    protected abstract Class<Mo> getOutputMessageClass();
}

